/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.nio.ByteBuffer;
import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQDestination;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQSession_0_8;
import org.apache.qpid.client.BasicMessageProducer;
import org.apache.qpid.client.CustomJMSXProperty;
import org.apache.qpid.client.message.AMQMessageDelegate_0_8;
import org.apache.qpid.client.message.AbstractJMSMessage;
import org.apache.qpid.client.protocol.AMQProtocolHandler;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.BasicContentHeaderProperties;
import org.apache.qpid.framing.BasicPublishBody;
import org.apache.qpid.framing.CompositeAMQDataBlock;
import org.apache.qpid.framing.ContentBody;
import org.apache.qpid.framing.ContentHeaderBody;
import org.apache.qpid.framing.ExchangeDeclareBody;
import org.apache.qpid.framing.MethodRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicMessageProducer_0_8
extends BasicMessageProducer {
    private static final Logger _logger = LoggerFactory.getLogger(BasicMessageProducer_0_8.class);
    private static final boolean SET_EXPIRATION_AS_TTL = Boolean.getBoolean("qpid.set_expiration_as_ttl");

    BasicMessageProducer_0_8(AMQConnection connection, AMQDestination destination, boolean transacted, int channelId, AMQSession session, AMQProtocolHandler protocolHandler, long producerId, Boolean immediate, Boolean mandatory) throws AMQException {
        super(_logger, connection, destination, transacted, channelId, session, producerId, immediate, mandatory);
    }

    @Override
    void declareDestination(AMQDestination destination) {
        if (this.getSession().isDeclareExchanges()) {
            MethodRegistry methodRegistry = this.getSession().getMethodRegistry();
            ExchangeDeclareBody body = methodRegistry.createExchangeDeclareBody(this.getSession().getTicket(), destination.getExchangeName(), destination.getExchangeClass(), destination.getExchangeName().toString().startsWith("amq."), destination.isExchangeDurable(), destination.isExchangeAutoDelete(), destination.isExchangeInternal(), true, null);
            AMQFrame declare = body.generateFrame(this.getChannelId());
            this.getConnection().getProtocolHandler().writeFrame(declare);
        }
    }

    @Override
    void sendMessage(AMQDestination destination, Message origMessage, AbstractJMSMessage message, UUID messageId, int deliveryMode, int priority, long timeToLive, boolean mandatory, boolean immediate) throws JMSException {
        BasicPublishBody body = this.getSession().getMethodRegistry().createBasicPublishBody(this.getSession().getTicket(), destination.getExchangeName(), destination.getRoutingKey(), mandatory, immediate);
        AMQFrame publishFrame = body.generateFrame(this.getChannelId());
        message.prepareForSending();
        ByteBuffer payload = message.getData();
        AMQMessageDelegate_0_8 delegate = (AMQMessageDelegate_0_8)message.getDelegate();
        BasicContentHeaderProperties contentHeaderProperties = delegate.getContentHeaderProperties();
        contentHeaderProperties.setUserId(this.getUserID());
        int type = destination instanceof Topic ? 2 : (destination instanceof Queue ? 1 : 3);
        delegate.getContentHeaderProperties().getHeaders().setInteger(CustomJMSXProperty.JMS_QPID_DESTTYPE.getShortStringName(), type);
        if (!this.isDisableTimestamps()) {
            long currentTime = System.currentTimeMillis();
            contentHeaderProperties.setTimestamp(currentTime);
            if (timeToLive > 0L) {
                if (!SET_EXPIRATION_AS_TTL) {
                    contentHeaderProperties.setExpiration(currentTime + timeToLive);
                } else {
                    contentHeaderProperties.setExpiration(timeToLive);
                }
            } else {
                contentHeaderProperties.setExpiration(0L);
            }
        }
        contentHeaderProperties.setDeliveryMode((byte)deliveryMode);
        contentHeaderProperties.setPriority((byte)priority);
        int size = payload != null ? payload.limit() : 0;
        int contentBodyFrameCount = this.calculateContentBodyFrameCount(payload);
        AMQDataBlock[] frames = new AMQFrame[2 + contentBodyFrameCount];
        if (payload != null) {
            this.createContentBodies(payload, (AMQFrame[])frames, 2, this.getChannelId());
        }
        if (contentBodyFrameCount != 0 && this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Sending content body frames to " + destination);
        }
        int classIfForBasic = this.getSession().getMethodRegistry().createBasicQosOkBody().getClazz();
        AMQFrame contentHeaderFrame = ContentHeaderBody.createAMQFrame(this.getChannelId(), classIfForBasic, 0, contentHeaderProperties, size);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Sending content header frame to " + destination);
        }
        frames[0] = publishFrame;
        frames[1] = contentHeaderFrame;
        CompositeAMQDataBlock compositeFrame = new CompositeAMQDataBlock(frames);
        try {
            this.getSession().checkFlowControl();
        }
        catch (InterruptedException e) {
            JMSException jmse = new JMSException("Interrupted while waiting for flow control to be removed");
            jmse.setLinkedException((Exception)e);
            jmse.initCause((Throwable)e);
            throw jmse;
        }
        this.getConnection().getProtocolHandler().writeFrame(compositeFrame);
    }

    private void createContentBodies(ByteBuffer payload, AMQFrame[] frames, int offset, int channelId) {
        if (frames.length == offset + 1) {
            byte[] data = new byte[payload.remaining()];
            payload.get(data);
            frames[offset] = ContentBody.createAMQFrame(channelId, new ContentBody(data));
        } else {
            long framePayloadMax = this.getSession().getAMQConnection().getMaximumFrameSize() - 1L;
            long remaining = payload.remaining();
            for (int i = offset; i < frames.length; ++i) {
                payload.position((int)framePayloadMax * (i - offset));
                int length = remaining >= framePayloadMax ? (int)framePayloadMax : (int)remaining;
                payload.limit(payload.position() + length);
                byte[] data = new byte[payload.remaining()];
                payload.get(data);
                frames[i] = ContentBody.createAMQFrame(channelId, new ContentBody(data));
                remaining -= (long)length;
            }
        }
    }

    private int calculateContentBodyFrameCount(ByteBuffer payload) {
        int frameCount;
        if (payload == null || payload.remaining() == 0) {
            frameCount = 0;
        } else {
            long framePayloadMax;
            int dataLength = payload.remaining();
            int lastFrame = (long)dataLength % (framePayloadMax = this.getSession().getAMQConnection().getMaximumFrameSize() - 1L) > 0L ? 1 : 0;
            frameCount = (int)((long)dataLength / framePayloadMax) + lastFrame;
        }
        return frameCount;
    }

    @Override
    public AMQSession_0_8 getSession() {
        return (AMQSession_0_8)super.getSession();
    }
}

