/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.framing.AMQShortStringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AMQShortString
implements CharSequence,
Comparable<AMQShortString> {
    public static final int MAX_LENGTH = 255;
    private static final byte MINUS = 45;
    private static final byte ZERO = 48;
    private static final ConcurrentHashMap<AMQShortString, AMQShortString> _globalInternMap = new ConcurrentHashMap();
    private static final Logger _logger = LoggerFactory.getLogger(AMQShortString.class);
    private final byte[] _data;
    private final int _offset;
    private int _hashCode;
    private String _asString = null;
    private final int _length;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final AMQShortString EMPTY_STRING = new AMQShortString((String)null);

    private AMQShortString substring(int from, int to) {
        return new AMQShortString(this._data, from + this._offset, to - from);
    }

    public AMQShortString(byte[] data) {
        if (data == null) {
            throw new NullPointerException("Cannot create AMQShortString with null data[]");
        }
        if (data.length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        this._data = (byte[])data.clone();
        this._length = data.length;
        this._offset = 0;
    }

    public AMQShortString(String data) {
        this(data == null ? EMPTY_CHAR_ARRAY : data.toCharArray());
        this._asString = data;
    }

    public AMQShortString(char[] data) {
        if (data == null) {
            throw new NullPointerException("Cannot create AMQShortString with null char[]");
        }
        if (data.length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        int length = data.length;
        byte[] stringBytes = new byte[length];
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            stringBytes[i] = (byte)(0xFF & data[i]);
            hash = 31 * hash + stringBytes[i];
        }
        this._hashCode = hash;
        this._data = stringBytes;
        this._length = length;
        this._offset = 0;
    }

    public AMQShortString(CharSequence charSequence) {
        if (charSequence == null) {
            charSequence = "";
        }
        if (charSequence.length() > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        int length = charSequence.length();
        byte[] stringBytes = new byte[length];
        int hash = 0;
        for (int i = 0; i < length; ++i) {
            stringBytes[i] = (byte)(0xFF & charSequence.charAt(i));
            hash = 31 * hash + stringBytes[i];
        }
        this._data = stringBytes;
        this._hashCode = hash;
        this._length = length;
        this._offset = 0;
    }

    private AMQShortString(DataInput data, int length) throws IOException {
        if (length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        byte[] dataBytes = new byte[length];
        data.readFully(dataBytes);
        this._data = dataBytes;
        this._offset = 0;
        this._length = length;
    }

    public AMQShortString(byte[] data, int offset, int length) {
        if (length > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        if (data == null) {
            throw new NullPointerException("Cannot create AMQShortString with null data[]");
        }
        this._offset = offset;
        this._length = length;
        this._data = data;
    }

    public AMQShortString shrink() {
        if (this._data.length != this._length) {
            return this.copy();
        }
        return this;
    }

    @Override
    public int length() {
        return this._length;
    }

    @Override
    public char charAt(int index) {
        return (char)this._data[this._offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new CharSubSequence(start, end);
    }

    public static AMQShortString readFromBuffer(DataInput buffer) throws IOException {
        int length = buffer.readUnsignedByte();
        if (length == 0) {
            return null;
        }
        return new AMQShortString(buffer, length);
    }

    public byte[] getBytes() {
        if (this._offset == 0 && this._length == this._data.length) {
            return (byte[])this._data.clone();
        }
        byte[] data = new byte[this._length];
        System.arraycopy(this._data, this._offset, data, 0, this._length);
        return data;
    }

    public void writeToBuffer(DataOutput buffer) throws IOException {
        int size = this.length();
        buffer.writeByte(size);
        buffer.write(this._data, this._offset, size);
    }

    public boolean endsWith(String s) {
        return this.endsWith(new AMQShortString(s));
    }

    public boolean endsWith(AMQShortString otherString) {
        if (otherString.length() > this.length()) {
            return false;
        }
        int thisLength = this.length();
        int otherLength = otherString.length();
        for (int i = 1; i <= otherLength; ++i) {
            if (this.charAt(thisLength - i) == otherString.charAt(otherLength - i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String s) {
        return this.startsWith(new AMQShortString(s));
    }

    public boolean startsWith(AMQShortString otherString) {
        if (otherString.length() > this.length()) {
            return false;
        }
        for (int i = 0; i < otherString.length(); ++i) {
            if (this.charAt(i) == otherString.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(CharSequence otherString) {
        if (otherString.length() > this.length()) {
            return false;
        }
        for (int i = 0; i < otherString.length(); ++i) {
            if (this.charAt(i) == otherString.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public char[] asChars() {
        int size = this.length();
        char[] chars = new char[size];
        for (int i = 0; i < size; ++i) {
            chars[i] = (char)this._data[i + this._offset];
        }
        return chars;
    }

    public String asString() {
        if (this._asString == null) {
            AMQShortString intern = this.intern(false);
            this._asString = intern == this ? new String(this.asChars()) : intern.asString();
        }
        return this._asString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AMQShortString) {
            return this.equals((AMQShortString)o);
        }
        return false;
    }

    public boolean equals(AMQShortString otherString) {
        if (otherString == this) {
            return true;
        }
        if (otherString == null) {
            return false;
        }
        int hashCode = this._hashCode;
        int otherHashCode = otherString._hashCode;
        if (hashCode != 0 && otherHashCode != 0 && hashCode != otherHashCode) {
            return false;
        }
        int length = this._length;
        if (length != otherString._length) {
            return false;
        }
        byte[] data = this._data;
        byte[] otherData = otherString._data;
        int offset = this._offset;
        int otherOffset = otherString._offset;
        if (offset == 0 && otherOffset == 0 && length == data.length && length == otherData.length) {
            return Arrays.equals(data, otherData);
        }
        int thisIdx = offset;
        int otherIdx = otherOffset;
        int i = length;
        while (i-- != 0) {
            if (data[thisIdx++] == otherData[otherIdx++]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsCharSequence(CharSequence s) {
        if (s instanceof AMQShortString) {
            return this.equals((AMQShortString)s);
        }
        if (s == null) {
            return false;
        }
        if (s.length() != this.length()) {
            return false;
        }
        for (int i = 0; i < this.length(); ++i) {
            if (this.charAt(i) == s.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this._hashCode;
        if (hash == 0) {
            int size = this.length();
            for (int i = 0; i < size; ++i) {
                hash = 31 * hash + this._data[i + this._offset];
            }
            this._hashCode = hash;
        }
        return hash;
    }

    public void setDirty() {
        this._hashCode = 0;
    }

    @Override
    public String toString() {
        return this.asString();
    }

    @Override
    public int compareTo(AMQShortString name) {
        if (name == this) {
            return 0;
        }
        if (name == null) {
            return 1;
        }
        if (name.length() < this.length()) {
            return -name.compareTo(this);
        }
        for (int i = 0; i < this.length(); ++i) {
            byte d = this._data[i + this._offset];
            byte n = name._data[i + name._offset];
            if (d < n) {
                return -1;
            }
            if (d <= n) continue;
            return 1;
        }
        return this.length() == name.length() ? 0 : -1;
    }

    public AMQShortStringTokenizer tokenize(byte delim) {
        return new TokenizerImpl(delim);
    }

    public AMQShortString intern() {
        return this.intern(true);
    }

    public AMQShortString intern(boolean keep) {
        AMQShortString internString = keep ? _globalInternMap.putIfAbsent(this, this) : _globalInternMap.get(this);
        return internString == null ? this : internString;
    }

    private AMQShortString copy() {
        byte[] dataBytes = new byte[this._length];
        System.arraycopy(this._data, this._offset, dataBytes, 0, this._length);
        return new AMQShortString(dataBytes, 0, this._length);
    }

    private int occurrences(byte delim) {
        int count = 0;
        int end = this._offset + this._length;
        for (int i = this._offset; i < end; ++i) {
            if (this._data[i] != delim) continue;
            ++count;
        }
        return count;
    }

    private int indexOf(byte val, int pos) {
        for (int i = pos; i < this.length(); ++i) {
            if (this._data[this._offset + i] != val) continue;
            return i;
        }
        return -1;
    }

    public static AMQShortString join(Collection<AMQShortString> terms, AMQShortString delim) {
        if (terms.size() == 0) {
            return EMPTY_STRING;
        }
        int size = delim.length() * (terms.size() - 1);
        for (AMQShortString term : terms) {
            size += term.length();
        }
        if (size > 255) {
            throw new IllegalArgumentException("Cannot create AMQShortString with number of octets over 255!");
        }
        byte[] data = new byte[size];
        int pos = 0;
        byte[] delimData = delim._data;
        int delimOffset = delim._offset;
        int delimLength = delim._length;
        for (AMQShortString term : terms) {
            if (pos != 0) {
                System.arraycopy(delimData, delimOffset, data, pos, delimLength);
                pos += delimLength;
            }
            System.arraycopy(term._data, term._offset, data, pos, term._length);
            pos += term._length;
        }
        return new AMQShortString(data, 0, size);
    }

    public int toIntValue() {
        boolean isNegative;
        int pos = this._offset;
        int val = 0;
        boolean bl = isNegative = this._data[pos] == 45;
        if (isNegative) {
            ++pos;
        }
        int end = this._length + this._offset;
        while (pos < end) {
            int digit;
            if ((digit = this._data[pos++] - 48) < 0 || digit > 9) {
                throw new NumberFormatException("\"" + this.toString() + "\" is not a valid number");
            }
            val *= 10;
            val += digit;
        }
        if (isNegative) {
            val *= -1;
        }
        return val;
    }

    public boolean contains(byte b) {
        int end = this._length + this._offset;
        for (int i = this._offset; i < end; ++i) {
            if (this._data[i] != b) continue;
            return true;
        }
        return false;
    }

    public static AMQShortString validValueOf(Object obj) {
        return AMQShortString.valueOf(obj, true, true);
    }

    static AMQShortString valueOf(Object obj, boolean truncate, boolean nullAsEmptyString) {
        if (obj == null) {
            if (nullAsEmptyString) {
                return EMPTY_STRING;
            }
            return null;
        }
        String value = String.valueOf(obj);
        if (truncate && value.length() > 255) {
            value = value.substring(0, 252) + "...";
        }
        return AMQShortString.valueOf(value);
    }

    public static AMQShortString valueOf(Object obj) {
        return AMQShortString.valueOf(obj, false, false);
    }

    public static AMQShortString valueOf(String obj) {
        if (obj == null) {
            return null;
        }
        return new AMQShortString(obj);
    }

    public static String toString(AMQShortString amqShortString) {
        return amqShortString == null ? null : amqShortString.asString();
    }

    private final class CharSubSequence
    implements CharSequence {
        private final int _sequenceOffset;
        private final int _end;

        public CharSubSequence(int offset, int end) {
            this._sequenceOffset = offset;
            this._end = end;
        }

        @Override
        public int length() {
            return this._end - this._sequenceOffset;
        }

        @Override
        public char charAt(int index) {
            return AMQShortString.this.charAt(index + this._sequenceOffset);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new CharSubSequence(start + this._sequenceOffset, end + this._sequenceOffset);
        }
    }

    private final class TokenizerImpl
    implements AMQShortStringTokenizer {
        private final byte _delim;
        private int _count = -1;
        private int _pos = 0;

        public TokenizerImpl(byte delim) {
            this._delim = delim;
        }

        @Override
        public int countTokens() {
            if (this._count == -1) {
                this._count = 1 + AMQShortString.this.occurrences(this._delim);
            }
            return this._count;
        }

        @Override
        public AMQShortString nextToken() {
            if (this._pos <= AMQShortString.this.length()) {
                int nextDelim = AMQShortString.this.indexOf(this._delim, this._pos);
                if (nextDelim == -1) {
                    nextDelim = AMQShortString.this.length();
                }
                AMQShortString nextToken = AMQShortString.this.substring(this._pos, nextDelim++);
                this._pos = nextDelim;
                return nextToken;
            }
            return null;
        }

        @Override
        public boolean hasMoreTokens() {
            return this._pos <= AMQShortString.this.length();
        }
    }
}

