/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataInput;
import java.io.IOException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.BasicContentHeaderProperties;

public class ContentHeaderPropertiesFactory {
    private static final ContentHeaderPropertiesFactory _instance = new ContentHeaderPropertiesFactory();

    public static ContentHeaderPropertiesFactory getInstance() {
        return _instance;
    }

    private ContentHeaderPropertiesFactory() {
    }

    public BasicContentHeaderProperties createContentHeaderProperties(int classId, int propertyFlags, DataInput buffer, int size) throws AMQFrameDecodingException, IOException {
        if (classId != 60) {
            throw new AMQFrameDecodingException(null, "Unsupport content header class id: " + classId, null);
        }
        BasicContentHeaderProperties properties = new BasicContentHeaderProperties();
        properties.populatePropertiesFromBuffer(buffer, propertyFlags, size);
        return properties;
    }
}

