/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.AMQPInvalidClassException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.AMQType;
import org.apache.qpid.framing.AMQTypedValue;
import org.apache.qpid.framing.ByteArrayDataInput;
import org.apache.qpid.framing.EncodingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTable {
    private static final Logger _logger = LoggerFactory.getLogger(FieldTable.class);
    private static final String STRICT_AMQP_NAME = "STRICT_AMQP";
    private static final boolean STRICT_AMQP = Boolean.valueOf(System.getProperty("STRICT_AMQP", "false"));
    private byte[] _encodedForm;
    private int _encodedFormOffset;
    private LinkedHashMap<AMQShortString, AMQTypedValue> _properties = null;
    private long _encodedSize;
    private static final int INITIAL_HASHMAP_CAPACITY = 16;
    private static final int INITIAL_ENCODED_FORM_SIZE = 256;
    private final boolean _strictAMQP;

    public FieldTable() {
        this(STRICT_AMQP);
    }

    public FieldTable(boolean strictAMQP) {
        this._strictAMQP = strictAMQP;
    }

    public FieldTable(DataInput buffer, long length) throws IOException {
        this();
        this._encodedForm = new byte[(int)length];
        buffer.readFully(this._encodedForm);
        this._encodedSize = length;
    }

    public FieldTable(byte[] encodedForm, int offset, int length) throws IOException {
        this();
        this._encodedForm = encodedForm;
        this._encodedFormOffset = offset;
        this._encodedSize = length;
    }

    public boolean isClean() {
        return this._encodedForm != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQTypedValue getProperty(AMQShortString string) {
        this.checkPropertyName(string);
        FieldTable fieldTable = this;
        synchronized (fieldTable) {
            if (this._properties == null) {
                if (this._encodedForm == null) {
                    return null;
                }
                this.populateFromBuffer();
            }
        }
        if (this._properties == null) {
            return null;
        }
        return this._properties.get(string);
    }

    private void populateFromBuffer() {
        try {
            this.setFromBuffer();
        }
        catch (AMQFrameDecodingException e) {
            _logger.error("Error decoding FieldTable in deferred decoding mode ", (Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            _logger.error("Unexpected IO exception decoding field table");
            throw new IllegalArgumentException(e);
        }
    }

    private AMQTypedValue setProperty(AMQShortString key, AMQTypedValue val) {
        AMQTypedValue oldVal;
        this.checkPropertyName(key);
        this.initMapIfNecessary();
        if (this._properties.containsKey(key)) {
            this._encodedForm = null;
            if (val == null) {
                return this.removeKey(key);
            }
        } else if (this._encodedForm != null && val != null) {
            this._encodedForm = null;
        } else if (val == null) {
            return null;
        }
        this._encodedSize = (oldVal = this._properties.put(key, val)) != null ? (this._encodedSize -= (long)oldVal.getEncodingSize()) : (this._encodedSize += (long)(EncodingUtils.encodedShortStringLength(key) + 1));
        this._encodedSize += (long)val.getEncodingSize();
        return oldVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMapIfNecessary() {
        FieldTable fieldTable = this;
        synchronized (fieldTable) {
            if (this._properties == null) {
                if (this._encodedForm == null || this._encodedSize == 0L) {
                    this._properties = new LinkedHashMap();
                } else {
                    this.populateFromBuffer();
                }
            }
        }
    }

    public Boolean getBoolean(String string) {
        return this.getBoolean(AMQShortString.valueOf(string));
    }

    public Boolean getBoolean(AMQShortString string) {
        AMQTypedValue value = this.getProperty(string);
        if (value != null && value.getType() == AMQType.BOOLEAN) {
            return (Boolean)value.getValue();
        }
        return null;
    }

    public Byte getByte(String string) {
        return this.getByte(AMQShortString.valueOf(string));
    }

    public Byte getByte(AMQShortString string) {
        AMQTypedValue value = this.getProperty(string);
        if (value != null && value.getType() == AMQType.BYTE) {
            return (Byte)value.getValue();
        }
        return null;
    }

    public Short getShort(String string) {
        return this.getShort(AMQShortString.valueOf(string));
    }

    public Short getShort(AMQShortString string) {
        AMQTypedValue value = this.getProperty(string);
        if (value != null && value.getType() == AMQType.SHORT) {
            return (Short)value.getValue();
        }
        return null;
    }

    public Integer getInteger(String string) {
        return this.getInteger(AMQShortString.valueOf(string));
    }

    public Integer getInteger(AMQShortString string) {
        AMQTypedValue value = this.getProperty(string);
        if (value != null && value.getType() == AMQType.INT) {
            return (Integer)value.getValue();
        }
        return null;
    }

    public Long getLong(String string) {
        return this.getLong(AMQShortString.valueOf(string));
    }

    public Long getLong(AMQShortString string) {
        AMQTypedValue value = this.getProperty(string);
        if (value != null && value.getType() == AMQType.LONG) {
            return (Long)value.getValue();
        }
        return null;
    }

    public Float getFloat(String string) {
        return this.getFloat(AMQShortString.valueOf(string));
    }

    public Float getFloat(AMQShortString string) {
        AMQTypedValue value = this.getProperty(string);
        if (value != null && value.getType() == AMQType.FLOAT) {
            return (Float)value.getValue();
        }
        return null;
    }

    public Double getDouble(String string) {
        return this.getDouble(AMQShortString.valueOf(string));
    }

    public Double getDouble(AMQShortString string) {
        AMQTypedValue value = this.getProperty(string);
        if (value != null && value.getType() == AMQType.DOUBLE) {
            return (Double)value.getValue();
        }
        return null;
    }

    public String getString(String string) {
        return this.getString(AMQShortString.valueOf(string));
    }

    public String getString(AMQShortString string) {
        AMQTypedValue value = this.getProperty(string);
        if (value != null && (value.getType() == AMQType.WIDE_STRING || value.getType() == AMQType.ASCII_STRING)) {
            return (String)value.getValue();
        }
        if (value != null && value.getValue() != null && !(value.getValue() instanceof byte[])) {
            return String.valueOf(value.getValue());
        }
        return null;
    }

    public Character getCharacter(String string) {
        return this.getCharacter(AMQShortString.valueOf(string));
    }

    public Character getCharacter(AMQShortString string) {
        AMQTypedValue value = this.getProperty(string);
        if (value != null && value.getType() == AMQType.ASCII_CHARACTER) {
            return (Character)value.getValue();
        }
        return null;
    }

    public byte[] getBytes(String string) {
        return this.getBytes(AMQShortString.valueOf(string));
    }

    public byte[] getBytes(AMQShortString string) {
        AMQTypedValue value = this.getProperty(string);
        if (value != null && value.getType() == AMQType.BINARY) {
            return (byte[])value.getValue();
        }
        return null;
    }

    public FieldTable getFieldTable(String string) {
        return this.getFieldTable(AMQShortString.valueOf(string));
    }

    public FieldTable getFieldTable(AMQShortString string) {
        AMQTypedValue value = this.getProperty(string);
        if (value != null && value.getType() == AMQType.FIELD_TABLE) {
            return (FieldTable)value.getValue();
        }
        return null;
    }

    public Object getObject(String string) {
        return this.getObject(AMQShortString.valueOf(string));
    }

    public Object getObject(AMQShortString string) {
        AMQTypedValue value = this.getProperty(string);
        if (value != null) {
            return value.getValue();
        }
        return value;
    }

    public Long getTimestamp(AMQShortString name) {
        AMQTypedValue value = this.getProperty(name);
        if (value != null && value.getType() == AMQType.TIMESTAMP) {
            return (Long)value.getValue();
        }
        return null;
    }

    public BigDecimal getDecimal(AMQShortString propertyName) {
        AMQTypedValue value = this.getProperty(propertyName);
        if (value != null && value.getType() == AMQType.DECIMAL) {
            return (BigDecimal)value.getValue();
        }
        return null;
    }

    public Object setBoolean(String string, Boolean b) {
        return this.setBoolean(AMQShortString.valueOf(string), b);
    }

    public Object setBoolean(AMQShortString string, Boolean b) {
        return this.setProperty(string, AMQType.BOOLEAN.asTypedValue(b));
    }

    public Object setByte(String string, Byte b) {
        return this.setByte(AMQShortString.valueOf(string), b);
    }

    public Object setByte(AMQShortString string, Byte b) {
        return this.setProperty(string, AMQType.BYTE.asTypedValue(b));
    }

    public Object setShort(String string, Short i) {
        return this.setShort(AMQShortString.valueOf(string), i);
    }

    public Object setShort(AMQShortString string, Short i) {
        return this.setProperty(string, AMQType.SHORT.asTypedValue(i));
    }

    public Object setInteger(String string, int i) {
        return this.setInteger(AMQShortString.valueOf(string), i);
    }

    public Object setInteger(AMQShortString string, int i) {
        return this.setProperty(string, AMQTypedValue.createAMQTypedValue(i));
    }

    public Object setLong(String string, long l) {
        return this.setLong(AMQShortString.valueOf(string), l);
    }

    public Object setLong(AMQShortString string, long l) {
        return this.setProperty(string, AMQTypedValue.createAMQTypedValue(l));
    }

    public Object setFloat(String string, Float f) {
        return this.setFloat(AMQShortString.valueOf(string), f);
    }

    public Object setFloat(AMQShortString string, Float v) {
        return this.setProperty(string, AMQType.FLOAT.asTypedValue(v));
    }

    public Object setDouble(String string, Double d) {
        return this.setDouble(AMQShortString.valueOf(string), d);
    }

    public Object setDouble(AMQShortString string, Double v) {
        return this.setProperty(string, AMQType.DOUBLE.asTypedValue(v));
    }

    public Object setString(String string, String s) {
        return this.setString(AMQShortString.valueOf(string), s);
    }

    public Object setAsciiString(AMQShortString string, String value) {
        if (value == null) {
            return this.setProperty(string, AMQType.VOID.asTypedValue(null));
        }
        return this.setProperty(string, AMQType.ASCII_STRING.asTypedValue(value));
    }

    public Object setString(AMQShortString string, String value) {
        if (value == null) {
            return this.setProperty(string, AMQType.VOID.asTypedValue(null));
        }
        return this.setProperty(string, AMQType.LONG_STRING.asTypedValue(value));
    }

    public Object setChar(String string, char c) {
        return this.setChar(AMQShortString.valueOf(string), c);
    }

    public Object setChar(AMQShortString string, char c) {
        return this.setProperty(string, AMQType.ASCII_CHARACTER.asTypedValue(Character.valueOf(c)));
    }

    public Object setBytes(String string, byte[] b) {
        return this.setBytes(AMQShortString.valueOf(string), b);
    }

    public Object setBytes(AMQShortString string, byte[] bytes) {
        return this.setProperty(string, AMQType.BINARY.asTypedValue(bytes));
    }

    public Object setBytes(String string, byte[] bytes, int start, int length) {
        return this.setBytes(AMQShortString.valueOf(string), bytes, start, length);
    }

    public Object setBytes(AMQShortString string, byte[] bytes, int start, int length) {
        byte[] newBytes = new byte[length];
        System.arraycopy(bytes, start, newBytes, 0, length);
        return this.setBytes(string, bytes);
    }

    public Object setObject(String string, Object o) {
        return this.setObject(AMQShortString.valueOf(string), o);
    }

    public Object setTimestamp(AMQShortString string, long datetime) {
        return this.setProperty(string, AMQType.TIMESTAMP.asTypedValue(datetime));
    }

    public Object setDecimal(AMQShortString string, BigDecimal decimal) {
        if (decimal.longValue() > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("AMQP doesnot support decimals larger than 2147483647");
        }
        if (decimal.scale() > 127) {
            throw new UnsupportedOperationException("AMQP doesnot support decimal scales larger than 127");
        }
        return this.setProperty(string, AMQType.DECIMAL.asTypedValue(decimal));
    }

    public Object setVoid(AMQShortString string) {
        return this.setProperty(string, AMQType.VOID.asTypedValue(null));
    }

    public Object setFieldTable(String string, FieldTable ftValue) {
        return this.setFieldTable(AMQShortString.valueOf(string), ftValue);
    }

    public Object setFieldTable(AMQShortString string, FieldTable ftValue) {
        return this.setProperty(string, AMQType.FIELD_TABLE.asTypedValue(ftValue));
    }

    public Object setObject(AMQShortString string, Object object) {
        if (object instanceof Boolean) {
            return this.setBoolean(string, (Boolean)object);
        }
        if (object instanceof Byte) {
            return this.setByte(string, (Byte)object);
        }
        if (object instanceof Short) {
            return this.setShort(string, (Short)object);
        }
        if (object instanceof Integer) {
            return this.setInteger(string, (int)((Integer)object));
        }
        if (object instanceof Long) {
            return this.setLong(string, (long)((Long)object));
        }
        if (object instanceof Float) {
            return this.setFloat(string, (Float)object);
        }
        if (object instanceof Double) {
            return this.setDouble(string, (Double)object);
        }
        if (object instanceof String) {
            return this.setString(string, (String)object);
        }
        if (object instanceof Character) {
            return this.setChar(string, ((Character)object).charValue());
        }
        if (object instanceof byte[]) {
            return this.setBytes(string, (byte[])object);
        }
        throw new AMQPInvalidClassException("Only Primitive objects allowed. Object is: " + (object == null ? "null" : object.getClass()));
    }

    public boolean isNullStringValue(String name) {
        AMQTypedValue value = this.getProperty(AMQShortString.valueOf(name));
        return value != null && value.getType() == AMQType.VOID;
    }

    public Enumeration getPropertyNames() {
        return Collections.enumeration(this.keys());
    }

    public boolean propertyExists(AMQShortString propertyName) {
        return this.itemExists(propertyName);
    }

    public boolean propertyExists(String propertyName) {
        return this.itemExists(propertyName);
    }

    public boolean itemExists(AMQShortString propertyName) {
        this.checkPropertyName(propertyName);
        this.initMapIfNecessary();
        return this._properties.containsKey(propertyName);
    }

    public boolean itemExists(String string) {
        return this.itemExists(AMQShortString.valueOf(string));
    }

    public String toString() {
        this.initMapIfNecessary();
        return this._properties.toString();
    }

    private void checkPropertyName(AMQShortString propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Property name must not be null");
        }
        if (propertyName.length() == 0) {
            throw new IllegalArgumentException("Property name must not be the empty string");
        }
        if (this._strictAMQP) {
            FieldTable.checkIdentiferFormat(propertyName);
        }
    }

    protected static void checkIdentiferFormat(AMQShortString propertyName) {
        if (propertyName.length() > 128) {
            throw new IllegalArgumentException("AMQP limits property names to 128 characters");
        }
        if (!Character.isLetter(propertyName.charAt(0)) && propertyName.charAt(0) != '$' && propertyName.charAt(0) != '#' && propertyName.charAt(0) != '_') {
            throw new IllegalArgumentException("Identifier '" + propertyName + "' does not start with a valid AMQP start character");
        }
    }

    public void writeToBuffer(DataOutput buffer) throws IOException {
        boolean trace = _logger.isDebugEnabled();
        if (trace) {
            _logger.debug("FieldTable::writeToBuffer: Writing encoded length of " + this.getEncodedSize() + "...");
            if (this._properties != null) {
                _logger.debug(this._properties.toString());
            }
        }
        EncodingUtils.writeUnsignedInteger(buffer, this.getEncodedSize());
        this.putDataInBuffer(buffer);
    }

    public byte[] getDataAsBytes() {
        if (this._encodedForm == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.putDataInBuffer(new DataOutputStream(baos));
                return baos.toByteArray();
            }
            catch (IOException e) {
                throw new IllegalArgumentException("IO Exception should never be thrown here");
            }
        }
        return (byte[])this._encodedForm.clone();
    }

    public long getEncodedSize() {
        return this._encodedSize;
    }

    private void recalculateEncodedSize() {
        int encodedSize = 0;
        if (this._properties != null) {
            for (Map.Entry<AMQShortString, AMQTypedValue> e : this._properties.entrySet()) {
                encodedSize += EncodingUtils.encodedShortStringLength(e.getKey());
                ++encodedSize;
                encodedSize += e.getValue().getEncodingSize();
            }
        }
        this._encodedSize = encodedSize;
    }

    public void addAll(FieldTable fieldTable) {
        this.initMapIfNecessary();
        fieldTable.initMapIfNecessary();
        if (fieldTable._properties != null) {
            this._encodedForm = null;
            this._properties.putAll(fieldTable._properties);
            this.recalculateEncodedSize();
        }
    }

    public static Map<String, Object> convertToMap(FieldTable fieldTable) {
        final HashMap<String, Object> map = new HashMap<String, Object>();
        if (fieldTable != null) {
            fieldTable.processOverElements(new FieldTableElementProcessor(){

                @Override
                public boolean processElement(String propertyName, AMQTypedValue value) {
                    Object val = value.getValue();
                    if (val instanceof AMQShortString) {
                        val = val.toString();
                    }
                    map.put(propertyName, val);
                    return true;
                }

                @Override
                public Object getResult() {
                    return map;
                }
            });
        }
        return map;
    }

    public Object processOverElements(FieldTableElementProcessor processor) {
        block1: {
            Map.Entry<AMQShortString, AMQTypedValue> e;
            boolean result;
            this.initMapIfNecessary();
            if (this._properties == null) break block1;
            Iterator<Map.Entry<AMQShortString, AMQTypedValue>> i$ = this._properties.entrySet().iterator();
            while (i$.hasNext() && (result = processor.processElement((e = i$.next()).getKey().toString(), e.getValue()))) {
            }
        }
        return processor.getResult();
    }

    public int size() {
        this.initMapIfNecessary();
        return this._properties.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(AMQShortString key) {
        this.initMapIfNecessary();
        return this._properties.containsKey(key);
    }

    public boolean containsKey(String key) {
        return this.containsKey(AMQShortString.valueOf(key));
    }

    public Set<String> keys() {
        this.initMapIfNecessary();
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (AMQShortString key : this._properties.keySet()) {
            keys.add(key.toString());
        }
        return keys;
    }

    public Iterator<Map.Entry<AMQShortString, AMQTypedValue>> iterator() {
        this.initMapIfNecessary();
        return this._properties.entrySet().iterator();
    }

    public Object get(String key) {
        return this.get(AMQShortString.valueOf(key));
    }

    public Object get(AMQShortString key) {
        return this.getObject(key);
    }

    public Object put(AMQShortString key, Object value) {
        return this.setObject(key, value);
    }

    public Object remove(String key) {
        return this.remove(AMQShortString.valueOf(key));
    }

    public Object remove(AMQShortString key) {
        AMQTypedValue val = this.removeKey(key);
        return val == null ? null : val.getValue();
    }

    public AMQTypedValue removeKey(AMQShortString key) {
        this.initMapIfNecessary();
        this._encodedForm = null;
        AMQTypedValue value = (AMQTypedValue)this._properties.remove(key);
        if (value == null) {
            return null;
        }
        this._encodedSize -= (long)EncodingUtils.encodedShortStringLength(key);
        --this._encodedSize;
        this._encodedSize -= (long)value.getEncodingSize();
        return value;
    }

    public void clear() {
        this.initMapIfNecessary();
        this._encodedForm = null;
        this._properties.clear();
        this._encodedSize = 0L;
    }

    public Set<AMQShortString> keySet() {
        this.initMapIfNecessary();
        return this._properties.keySet();
    }

    private void putDataInBuffer(DataOutput buffer) throws IOException {
        if (this._encodedForm != null) {
            buffer.write(this._encodedForm, this._encodedFormOffset, (int)this._encodedSize);
        } else if (this._properties != null) {
            for (Map.Entry<AMQShortString, AMQTypedValue> me : this._properties.entrySet()) {
                try {
                    EncodingUtils.writeShortStringBytes(buffer, me.getKey());
                    me.getValue().writeToBuffer(buffer);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private void setFromBuffer() throws AMQFrameDecodingException, IOException {
        ByteArrayDataInput baid = new ByteArrayDataInput(this._encodedForm, this._encodedFormOffset, (int)this._encodedSize);
        if (this._encodedSize > 0L) {
            this._properties = new LinkedHashMap(16);
            do {
                AMQShortString key = baid.readAMQShortString();
                AMQTypedValue value = AMQTypedValue.readFromBuffer(baid);
                this._properties.put(key, value);
            } while (baid.available() > 0);
        }
    }

    public int hashCode() {
        this.initMapIfNecessary();
        return this._properties.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof FieldTable)) {
            return false;
        }
        this.initMapIfNecessary();
        FieldTable f = (FieldTable)o;
        f.initMapIfNecessary();
        return this._properties.equals(f._properties);
    }

    public static FieldTable convertToFieldTable(Map<String, Object> map) {
        if (map != null) {
            FieldTable table = new FieldTable();
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                table.put(AMQShortString.valueOf(entry.getKey()), entry.getValue());
            }
            return table;
        }
        return null;
    }

    public static interface FieldTableElementProcessor {
        public boolean processElement(String var1, AMQTypedValue var2);

        public Object getResult();
    }
}

