/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_91;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.QueueUnbindBody;
import org.apache.qpid.framing.amqp_0_91.AMQMethodBody_0_91;
import org.apache.qpid.framing.amqp_0_91.MethodDispatcher_0_91;

public class QueueUnbindBodyImpl
extends AMQMethodBody_0_91
implements QueueUnbindBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new QueueUnbindBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 50;
    private final int _ticket;
    private final AMQShortString _queue;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final FieldTable _arguments;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public QueueUnbindBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._ticket = this.readUnsignedShort(buffer);
        this._queue = this.readAMQShortString(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._routingKey = this.readAMQShortString(buffer);
        this._arguments = this.readFieldTable(buffer);
    }

    public QueueUnbindBodyImpl(int ticket, AMQShortString queue, AMQShortString exchange, AMQShortString routingKey, FieldTable arguments) {
        this._ticket = ticket;
        this._queue = queue;
        this._exchange = exchange;
        this._routingKey = routingKey;
        this._arguments = arguments;
    }

    @Override
    public int getClazz() {
        return 50;
    }

    @Override
    public int getMethod() {
        return 50;
    }

    @Override
    public final int getTicket() {
        return this._ticket;
    }

    @Override
    public final AMQShortString getQueue() {
        return this._queue;
    }

    @Override
    public final AMQShortString getExchange() {
        return this._exchange;
    }

    @Override
    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    @Override
    public final FieldTable getArguments() {
        return this._arguments;
    }

    @Override
    protected int getBodySize() {
        int size = 2;
        size += this.getSizeOf(this._queue);
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._routingKey);
        return size += this.getSizeOf(this._arguments);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeFieldTable(buffer, this._arguments);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchQueueUnbind(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueUnbindBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("arguments=");
        buf.append(this.getArguments());
        buf.append("]");
        return buf.toString();
    }
}

