/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import org.apache.qpid.transport.ExecutionException;
import org.apache.qpid.transport.ExecutionResult;
import org.apache.qpid.transport.ExecutionSync;
import org.apache.qpid.transport.MessageCreditUnit;
import org.apache.qpid.transport.MessageFlow;
import org.apache.qpid.transport.MessageFlowMode;
import org.apache.qpid.transport.MessageSetFlowMode;
import org.apache.qpid.transport.MessageStop;
import org.apache.qpid.transport.MessageTransfer;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.ProtocolDelegate;
import org.apache.qpid.transport.ProtocolError;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.Range;
import org.apache.qpid.transport.RangeSet;
import org.apache.qpid.transport.RangeSetFactory;
import org.apache.qpid.transport.Session;
import org.apache.qpid.transport.SessionAttached;
import org.apache.qpid.transport.SessionCommandPoint;
import org.apache.qpid.transport.SessionCompleted;
import org.apache.qpid.transport.SessionException;
import org.apache.qpid.transport.SessionFlush;
import org.apache.qpid.transport.SessionKnownCompleted;
import org.apache.qpid.transport.SessionRequestTimeout;
import org.apache.qpid.transport.SessionTimeout;
import org.apache.qpid.transport.util.Logger;

public class SessionDelegate
extends MethodDelegate<Session>
implements ProtocolDelegate<Session> {
    protected static final Logger log = Logger.get(SessionDelegate.class);

    @Override
    public void init(Session ssn, ProtocolHeader hdr) {
        log.warn("INIT: [%s] %s", ssn, hdr);
    }

    @Override
    public void control(Session ssn, Method method) {
        method.dispatch(ssn, this);
    }

    @Override
    public void command(Session ssn, Method method) {
        this.command(ssn, method, !method.hasPayload());
    }

    public void command(Session ssn, Method method, boolean processed) {
        ssn.identify(method);
        method.dispatch(ssn, this);
        if (processed) {
            ssn.processed(method);
        }
    }

    @Override
    public void error(Session ssn, ProtocolError error) {
        log.warn("ERROR: [%s] %s", ssn, error);
    }

    @Override
    public void handle(Session ssn, Method method) {
        log.warn("UNHANDLED: [%s] %s", ssn, method);
    }

    @Override
    public void sessionRequestTimeout(Session ssn, SessionRequestTimeout t) {
        if (t.getTimeout() == 0L) {
            ssn.setClose(true);
        }
        ssn.sessionTimeout(0L, new Option[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sessionAttached(Session ssn, SessionAttached atc) {
        ssn.setState(Session.State.OPEN);
        Object object = ssn.getStateLock();
        synchronized (object) {
            ssn.getStateLock().notifyAll();
        }
    }

    @Override
    public void sessionTimeout(Session ssn, SessionTimeout t) {
    }

    @Override
    public void sessionCompleted(Session ssn, SessionCompleted cmp) {
        RangeSet ranges = cmp.getCommands();
        RangeSet known = null;
        if (ranges != null) {
            if (ranges.size() == 1) {
                Range range = ranges.getFirst();
                boolean advanced = ssn.complete(range.getLower(), range.getUpper());
                if (advanced && cmp.getTimelyReply()) {
                    known = range;
                }
            } else {
                if (cmp.getTimelyReply()) {
                    known = RangeSetFactory.createRangeSet();
                }
                for (Range range : ranges) {
                    boolean advanced = ssn.complete(range.getLower(), range.getUpper());
                    if (!advanced || known == null) continue;
                    known.add(range);
                }
            }
        } else if (cmp.getTimelyReply()) {
            known = RangeSetFactory.createRangeSet();
        }
        if (known != null) {
            ssn.sessionKnownCompleted(known, new Option[0]);
        }
    }

    @Override
    public void sessionKnownCompleted(Session ssn, SessionKnownCompleted kcmp) {
        RangeSet kc = kcmp.getCommands();
        if (kc != null) {
            ssn.knownComplete(kc);
        }
    }

    @Override
    public void sessionFlush(Session ssn, SessionFlush flush) {
        if (flush.getCompleted()) {
            ssn.flushProcessed(new Option[0]);
        }
        if (flush.getConfirmed()) {
            ssn.flushProcessed(new Option[0]);
        }
        if (flush.getExpected()) {
            ssn.flushExpected();
        }
    }

    @Override
    public void sessionCommandPoint(Session ssn, SessionCommandPoint scp) {
        ssn.commandPoint(scp.getCommandId());
    }

    @Override
    public void executionSync(Session ssn, ExecutionSync sync) {
        ssn.syncPoint();
    }

    @Override
    public void executionResult(Session ssn, ExecutionResult result) {
        ssn.result(result.getCommandId(), result.getValue());
    }

    @Override
    public void executionException(Session ssn, ExecutionException exc) {
        ssn.setException(exc);
        ssn.getSessionListener().exception(ssn, new SessionException(exc));
        ssn.closed();
    }

    @Override
    public void messageTransfer(Session ssn, MessageTransfer xfr) {
        ssn.getSessionListener().message(ssn, xfr);
    }

    @Override
    public void messageSetFlowMode(Session ssn, MessageSetFlowMode sfm) {
        if ("".equals(sfm.getDestination()) && MessageFlowMode.CREDIT.equals((Object)sfm.getFlowMode())) {
            ssn.setFlowControl(true);
        } else {
            super.messageSetFlowMode(ssn, sfm);
        }
    }

    @Override
    public void messageFlow(Session ssn, MessageFlow flow) {
        if ("".equals(flow.getDestination()) && MessageCreditUnit.MESSAGE.equals((Object)flow.getUnit())) {
            ssn.addCredit((int)flow.getValue());
        } else {
            super.messageFlow(ssn, flow);
        }
    }

    @Override
    public void messageStop(Session ssn, MessageStop stop) {
        if ("".equals(stop.getDestination())) {
            ssn.drainCredit();
        } else {
            super.messageStop(ssn, stop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed(Session session) {
        log.debug("CLOSED: [%s]", session);
        Object object = session.getStateLock();
        synchronized (object) {
            session.getStateLock().notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detached(Session session) {
        log.debug("DETACHED: [%s]", session);
        Object object = session.getStateLock();
        synchronized (object) {
            session.getStateLock().notifyAll();
        }
    }
}

