/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.io;

import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.Principal;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.network.NetworkConnection;
import org.apache.qpid.transport.network.Ticker;
import org.apache.qpid.transport.network.io.IoReceiver;
import org.apache.qpid.transport.network.io.IoSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoNetworkConnection
implements NetworkConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoNetworkConnection.class);
    private final Socket _socket;
    private final long _timeout;
    private final IoSender _ioSender;
    private final IoReceiver _ioReceiver;
    private int _maxReadIdle;
    private int _maxWriteIdle;
    private Principal _principal;
    private boolean _principalChecked;
    private final Object _lock = new Object();

    public IoNetworkConnection(Socket socket, Receiver<ByteBuffer> delegate, int sendBufferSize, int receiveBufferSize, long timeout, Ticker ticker) {
        this._socket = socket;
        this._timeout = timeout;
        this._ioReceiver = new IoReceiver(this._socket, delegate, receiveBufferSize, this._timeout);
        this._ioReceiver.setTicker(ticker);
        this._ioSender = new IoSender(this._socket, 2 * sendBufferSize, this._timeout);
        this._ioSender.registerCloseListener(this._ioReceiver);
    }

    @Override
    public void start() {
        this._ioSender.initiate();
        this._ioReceiver.initiate();
    }

    @Override
    public Sender<ByteBuffer> getSender() {
        return this._ioSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this._ioSender.close();
        }
        finally {
            this._ioReceiver.close(false);
        }
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this._socket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this._socket.getLocalSocketAddress();
    }

    @Override
    public void setMaxWriteIdle(int sec) {
        this._maxWriteIdle = sec;
    }

    @Override
    public void setMaxReadIdle(int sec) {
        this._maxReadIdle = sec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal getPeerPrincipal() {
        Object object = this._lock;
        synchronized (object) {
            if (!this._principalChecked) {
                if (this._socket instanceof SSLSocket) {
                    try {
                        this._principal = ((SSLSocket)this._socket).getSession().getPeerPrincipal();
                    }
                    catch (SSLPeerUnverifiedException e) {
                        this._principal = null;
                    }
                }
                this._principalChecked = true;
            }
            return this._principal;
        }
    }

    @Override
    public int getMaxReadIdle() {
        return this._maxReadIdle;
    }

    @Override
    public int getMaxWriteIdle() {
        return this._maxWriteIdle;
    }
}

