/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security.ssl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.util.Logger;

public class SSLUtil {
    private static final Logger log = Logger.get(SSLUtil.class);

    private SSLUtil() {
    }

    public static void verifyHostname(SSLEngine engine, String hostnameExpected) {
        try {
            Certificate cert = engine.getSession().getPeerCertificates()[0];
            Principal p = ((X509Certificate)cert).getSubjectDN();
            String dn = p.getName();
            String hostname = null;
            if (dn.contains("CN=")) {
                hostname = dn.substring(3, dn.indexOf(",") == -1 ? dn.length() : dn.indexOf(","));
            }
            if (log.isDebugEnabled()) {
                log.debug("Hostname expected : " + hostnameExpected, new Object[0]);
                log.debug("Distinguished Name for server certificate : " + dn, new Object[0]);
                log.debug("Host Name obtained from DN : " + hostname, new Object[0]);
            }
            if (hostname != null && !hostname.equalsIgnoreCase(hostnameExpected) && !hostname.equalsIgnoreCase(hostnameExpected + ".localdomain")) {
                throw new TransportException("SSL hostname verification failed. Expected : " + hostnameExpected + " Found in cert : " + hostname);
            }
        }
        catch (SSLPeerUnverifiedException e) {
            log.warn("Exception received while trying to verify hostname", e);
        }
    }

    public static String getIdFromSubjectDN(String dn) {
        String cnStr = null;
        String dcStr = null;
        if (dn == null) {
            return "";
        }
        try {
            LdapName ln = new LdapName(dn);
            for (Rdn rdn : ln.getRdns()) {
                if ("CN".equalsIgnoreCase(rdn.getType())) {
                    cnStr = rdn.getValue().toString();
                    continue;
                }
                if (!"DC".equalsIgnoreCase(rdn.getType())) continue;
                if (dcStr == null) {
                    dcStr = rdn.getValue().toString();
                    continue;
                }
                dcStr = rdn.getValue().toString() + '.' + dcStr;
            }
            return cnStr == null || cnStr.length() == 0 ? "" : (dcStr == null ? cnStr : cnStr + '@' + dcStr);
        }
        catch (InvalidNameException e) {
            log.warn("Invalid name: '" + dn + "'. ", new Object[0]);
            return "";
        }
    }

    public static String retrieveIdentity(SSLEngine engine) {
        String id = "";
        Certificate cert = engine.getSession().getLocalCertificates()[0];
        Principal p = ((X509Certificate)cert).getSubjectDN();
        String dn = p.getName();
        try {
            id = SSLUtil.getIdFromSubjectDN(dn);
        }
        catch (Exception e) {
            log.info("Exception received while trying to retrive client identity from SSL cert", e);
        }
        log.debug("Extracted Identity from client certificate : " + id, new Object[0]);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getInitializedKeyStore(String storePath, String storePassword, String keyStoreType) throws GeneralSecurityException, IOException {
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        InputStream in = null;
        try {
            File f = new File(storePath);
            in = f.exists() ? new FileInputStream(f) : Thread.currentThread().getContextClassLoader().getResourceAsStream(storePath);
            if (in == null && !"PKCS11".equalsIgnoreCase(keyStoreType)) {
                throw new IOException("Unable to load keystore resource: " + storePath);
            }
            char[] storeCharPassword = storePassword == null ? null : storePassword.toCharArray();
            ks.load(in, storeCharPassword);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ignored) {}
            }
        }
        return ks;
    }
}

