/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.util;

import java.io.DataOutput;

public class BytesDataOutput
implements DataOutput {
    private int _pos = 0;
    private byte[] _buf;

    public BytesDataOutput(byte[] buf) {
        this._buf = buf;
    }

    public void setBuffer(byte[] buf) {
        this._buf = buf;
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
    }

    public int length() {
        return this._pos;
    }

    @Override
    public void write(int b) {
        this._buf[this._pos++] = (byte)b;
    }

    @Override
    public void write(byte[] b) {
        System.arraycopy(b, 0, this._buf, this._pos, b.length);
        this._pos += b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        System.arraycopy(b, off, this._buf, this._pos, len);
        this._pos += len;
    }

    @Override
    public void writeBoolean(boolean v) {
        this._buf[this._pos++] = v ? (byte)1 : 0;
    }

    @Override
    public void writeByte(int v) {
        this._buf[this._pos++] = (byte)v;
    }

    @Override
    public void writeShort(int v) {
        this._buf[this._pos++] = (byte)(v >>> 8);
        this._buf[this._pos++] = (byte)v;
    }

    @Override
    public void writeChar(int v) {
        this._buf[this._pos++] = (byte)(v >>> 8);
        this._buf[this._pos++] = (byte)v;
    }

    @Override
    public void writeInt(int v) {
        this._buf[this._pos++] = (byte)(v >>> 24);
        this._buf[this._pos++] = (byte)(v >>> 16);
        this._buf[this._pos++] = (byte)(v >>> 8);
        this._buf[this._pos++] = (byte)v;
    }

    @Override
    public void writeLong(long v) {
        this._buf[this._pos++] = (byte)(v >>> 56);
        this._buf[this._pos++] = (byte)(v >>> 48);
        this._buf[this._pos++] = (byte)(v >>> 40);
        this._buf[this._pos++] = (byte)(v >>> 32);
        this._buf[this._pos++] = (byte)(v >>> 24);
        this._buf[this._pos++] = (byte)(v >>> 16);
        this._buf[this._pos++] = (byte)(v >>> 8);
        this._buf[this._pos++] = (byte)v;
    }

    @Override
    public void writeFloat(float v) {
        this.writeInt(Float.floatToIntBits(v));
    }

    @Override
    public void writeDouble(double v) {
        this.writeLong(Double.doubleToLongBits(v));
    }

    @Override
    public void writeBytes(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            this._buf[this._pos++] = (byte)s.charAt(i);
        }
    }

    @Override
    public void writeChars(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char v = s.charAt(i);
            this._buf[this._pos++] = (byte)(v >>> 8);
            this._buf[this._pos++] = (byte)v;
        }
    }

    @Override
    public void writeUTF(String s) {
        int strlen = s.length();
        int pos = this._pos;
        this._pos += 2;
        for (int i = 0; i < strlen; ++i) {
            char c = s.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                c = s.charAt(i);
                this._buf[this._pos++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this._buf[this._pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                this._buf[this._pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                this._buf[this._pos++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            this._buf[this._pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this._buf[this._pos++] = (byte)(0x80 | c & 0x3F);
        }
        int len = this._pos - (pos + 2);
        this._buf[pos++] = (byte)(len >>> 8);
        this._buf[pos] = (byte)len;
    }
}

