/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jndi.command;

import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.jndi.command.JndiCommandSupport;

@Command(scope="jndi", name="names", description="List the JNDI names.")
public class NamesCommand
extends JndiCommandSupport {
    private static final String NAMES_STRING_FORMAT = "%-20s %-60s";
    @Argument(index=0, name="context", description="The JNDI context to display the names", required=false, multiValued=false)
    String context;

    public Object doExecute() throws Exception {
        System.out.println(String.format(NAMES_STRING_FORMAT, "JNDI Name", "Class Name"));
        Map names = this.context == null ? this.getJndiService().names() : this.getJndiService().names(this.context);
        for (String name : names.keySet()) {
            System.out.println(String.format(NAMES_STRING_FORMAT, name, names.get(name)));
        }
        return null;
    }
}

