/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.network;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.jmx.AnnotatedMBean;
import org.apache.activemq.broker.jmx.BrokerMBeanSupport;
import org.apache.activemq.broker.jmx.NetworkBridgeView;
import org.apache.activemq.network.NetworkBridge;
import org.apache.activemq.network.NetworkBridgeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanNetworkListener
implements NetworkBridgeListener {
    private static final Logger LOG = LoggerFactory.getLogger(MBeanNetworkListener.class);
    BrokerService brokerService;
    ObjectName connectorName;
    boolean createdByDuplex = false;

    public MBeanNetworkListener(BrokerService brokerService, ObjectName connectorName) {
        this.brokerService = brokerService;
        this.connectorName = connectorName;
    }

    @Override
    public void bridgeFailed() {
    }

    @Override
    public void onStart(NetworkBridge bridge) {
        if (!this.brokerService.isUseJmx()) {
            return;
        }
        NetworkBridgeView view = new NetworkBridgeView(bridge);
        view.setCreateByDuplex(this.createdByDuplex);
        try {
            ObjectName objectName = this.createNetworkBridgeObjectName(bridge);
            AnnotatedMBean.registerMBean(this.brokerService.getManagementContext(), view, objectName);
            bridge.setMbeanObjectName(objectName);
            LOG.debug("registered: {} as: {}", (Object)bridge, (Object)objectName);
        }
        catch (Throwable e) {
            LOG.debug("Network bridge could not be registered in JMX: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Override
    public void onStop(NetworkBridge bridge) {
        if (!this.brokerService.isUseJmx()) {
            return;
        }
        try {
            ObjectName objectName = bridge.getMbeanObjectName();
            if (objectName != null) {
                this.brokerService.getManagementContext().unregisterMBean(objectName);
            }
        }
        catch (Throwable e) {
            LOG.debug("Network bridge could not be unregistered in JMX: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    protected ObjectName createNetworkBridgeObjectName(NetworkBridge bridge) throws MalformedObjectNameException {
        return BrokerMBeanSupport.createNetworkBridgeObjectName(this.connectorName, bridge.getRemoteAddress());
    }

    public void setCreatedByDuplex(boolean createdByDuplex) {
        this.createdByDuplex = createdByDuplex;
    }
}

