/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.util.Iterator;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.EndpointState;
import org.apache.qpid.proton.engine.Sender;
import org.apache.qpid.proton.engine.impl.DeliveryImpl;
import org.apache.qpid.proton.engine.impl.LinkImpl;
import org.apache.qpid.proton.engine.impl.SessionImpl;
import org.apache.qpid.proton.engine.impl.TransportSender;

public class SenderImpl
extends LinkImpl
implements Sender {
    private int _offered;
    private TransportSender _transportLink;
    private boolean _drained;

    SenderImpl(SessionImpl session, String name) {
        super(session, name);
    }

    @Override
    public void offer(int credits) {
        this._offered = credits;
    }

    @Override
    public int send(byte[] bytes, int offset, int length) {
        if (this.getLocalState() == EndpointState.CLOSED) {
            throw new IllegalStateException("send not allowed after the sender is closed.");
        }
        DeliveryImpl current = this.current();
        if (current == null || current.getLink() != this) {
            throw new IllegalArgumentException();
        }
        int sent = current.send(bytes, offset, length);
        if (sent > 0) {
            this.getSession().incrementOutgoingBytes(sent);
        }
        return sent;
    }

    @Override
    public void abort() {
    }

    @Override
    public Iterator<Delivery> unsettled() {
        return null;
    }

    @Override
    public void free() {
        this.getSession().freeSender(this);
        super.free();
    }

    @Override
    public boolean advance() {
        DeliveryImpl delivery = this.current();
        boolean advance = super.advance();
        if (advance && this._offered > 0) {
            --this._offered;
        }
        if (advance) {
            this.decrementCredit();
            delivery.addToTransportWorkList();
            this.getSession().incrementOutgoingDeliveries(1);
        }
        return advance;
    }

    boolean hasOfferedCredits() {
        return this._offered > 0;
    }

    @Override
    TransportSender getTransportLink() {
        return this._transportLink;
    }

    void setTransportLink(TransportSender transportLink) {
        this._transportLink = transportLink;
    }

    @Override
    boolean workUpdate(DeliveryImpl delivery) {
        return delivery == this.current() && this.hasCredit();
    }

    @Override
    public void setCredit(int credit) {
        super.setCredit(credit);
    }

    @Override
    public void drained() {
        if (this.getDrain()) {
            this._drained = true;
            this.setCredit(0);
            this.modified();
        }
    }

    boolean clearDrained() {
        boolean drained = this._drained;
        if (drained) {
            this._drained = false;
        }
        return drained;
    }
}

