/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.spi.InterceptStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentProcessorDefinitionInterceptStrategy
implements InterceptStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(CurrentProcessorDefinitionInterceptStrategy.class);
    public static final String CURRENT_PROCESSOR_DEFINITION = "org.fusesource.camel.component.sap.CurrentProcessorDefinition";

    public Processor wrapProcessorInInterceptors(CamelContext context, final ProcessorDefinition<?> definition, Processor target, Processor nextTarget) throws Exception {
        RouteDefinitionHelper.forceAssignIds((CamelContext)context, definition);
        return new DelegateAsyncProcessor(target){

            public boolean process(Exchange exchange, AsyncCallback callback) {
                LOG.debug("Setting current processor defintion '" + definition.getId() + "'");
                exchange.setProperty(CurrentProcessorDefinitionInterceptStrategy.CURRENT_PROCESSOR_DEFINITION, (Object)definition);
                return this.processor.process(exchange, callback);
            }
        };
    }
}

