/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.Component;
import org.apache.camel.Producer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;
import org.fusesource.camel.component.sap.SapIDocDestinationEndpoint;
import org.fusesource.camel.component.sap.SapQueuedIDocListDestinationComponent;
import org.fusesource.camel.component.sap.SapQueuedIDocListProducer;
import org.fusesource.camel.component.sap.model.idoc.DocumentList;
import org.fusesource.camel.component.sap.util.IDocUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="sap-qidoclist-destination", syntax="sap-qidoclist-destination:destination:queue:idocType:idocTypeExtension:systemRelease:applicationRelease", producerOnly=true, title="SAP Queued IDoc List Destination")
public class SapQueuedIDocListDestinationEndpoint
extends SapIDocDestinationEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SapQueuedIDocListDestinationEndpoint.class);
    @UriPath(name="queue", description="Specifies the queue this endpoint sends an IDoc to")
    @Metadata(required="true")
    protected String queueName;

    public SapQueuedIDocListDestinationEndpoint() {
    }

    public SapQueuedIDocListDestinationEndpoint(String endpointUri, SapQueuedIDocListDestinationComponent component) {
        super(endpointUri, (Component)component);
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public DocumentList createDocumentList() throws Exception {
        try {
            return IDocUtil.createDocumentList(this.getIDocRepository(), this.getIdocType(), this.getIdocTypeExtension(), this.getSystemRelease(), this.getApplicationRelease());
        }
        catch (Exception e) {
            throw new Exception("Failed to get Document List from endpoint", e);
        }
    }

    public Producer createProducer() throws Exception {
        LOG.debug("Created producer for endpoint '" + this.getEndpointUri() + "'");
        return new SapQueuedIDocListProducer(this);
    }
}

