/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SapRfcDestinationEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SapRfcDestinationEndpoint.class);
    @UriPath(name="destination", description="Specifies the destination this endpoint sends an SAP request to")
    @Metadata(required="true")
    protected String destinationName;
    @UriPath(name="rfc", description="Specifies the Remote Function Module this endpoint sends an SAP request to")
    @Metadata(required="true")
    protected String rfcName;
    @UriParam(name="transacted", description="When true, specifies that this endpoint will initiate an SAP transaction", defaultValue="false")
    protected boolean transacted;
    @UriParam(name="stateful", description="When true, specifies that this endpoint will initiate an SAP stateful session", defaultValue="false")
    protected boolean stateful;
    protected JCoDestination destination;

    public SapRfcDestinationEndpoint() {
    }

    public SapRfcDestinationEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("Endpoint '" + this.getEndpointUri() + "' does not support consumers");
    }

    public boolean isSingleton() {
        return true;
    }

    public String getDestinationName() {
        return this.destinationName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public String getRfcName() {
        return this.rfcName;
    }

    public void setRfcName(String rfcName) {
        this.rfcName = rfcName;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public Structure createRequest() throws Exception {
        return RfcUtil.getRequest(this.getDestination().getRepository(), this.getRfcName());
    }

    protected JCoDestination getDestination() {
        if (this.destination == null) {
            try {
                this.destination = JCoDestinationManager.getDestination((String)this.destinationName);
            }
            catch (Exception e) {
                LOG.warn("Failed to get destination object for endpoint '" + this.getEndpointUri() + "'. This exception will be ignored.", (Throwable)e);
            }
        }
        return this.destination;
    }
}

