/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap.converter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Converter;
import org.eclipse.emf.ecore.EObject;
import org.fusesource.camel.component.sap.model.rfc.Request;
import org.fusesource.camel.component.sap.model.rfc.impl.RequestImpl;
import org.fusesource.camel.component.sap.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Converter
public enum RequestConverter {
    INSTANCE;

    private static final Logger LOG;

    @Converter
    public static Request toRequest(String string) {
        try {
            EObject eObject = Util.unmarshal(string);
            if (RequestImpl.class.isInstance(eObject)) {
                return (RequestImpl)eObject;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to convert String to Request", (Throwable)e);
        }
        return null;
    }

    @Converter
    public static Request toRequest(InputStream in) {
        try {
            EObject eObject = Util.fromInputStream(in);
            if (RequestImpl.class.isInstance(eObject)) {
                return (RequestImpl)eObject;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to convert InputStream to Request", (Throwable)e);
        }
        return null;
    }

    @Converter
    public static Request toRequest(byte[] byteArray) {
        try {
            EObject eObject = Util.unmarshal(new String(byteArray));
            if (RequestImpl.class.isInstance(eObject)) {
                return (RequestImpl)eObject;
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to convert byte array to Request", (Throwable)e);
        }
        return null;
    }

    @Converter
    public static String toString(RequestImpl structure) {
        try {
            return Util.marshal(structure);
        }
        catch (IOException e) {
            LOG.warn("Failed to convert Request to String", (Throwable)e);
            return null;
        }
    }

    @Converter
    public static OutputStream toOutputStream(RequestImpl structure) {
        try {
            return Util.toOutputStream(structure);
        }
        catch (IOException e) {
            LOG.warn("Failed to convert Request to OutputStream", (Throwable)e);
            return null;
        }
    }

    @Converter
    public static InputStream toInputStream(RequestImpl structure) {
        try {
            return Util.toInputStream(structure);
        }
        catch (IOException e) {
            LOG.warn("Failed to convert Request to InputStream", (Throwable)e);
            return null;
        }
    }

    static {
        LOG = LoggerFactory.getLogger(RequestConverter.class);
    }
}

