/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.app.ActiveInitiator;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.Initiator;
import ca.uhn.hl7v2.app.Receiver;
import ca.uhn.hl7v2.app.Responder;
import ca.uhn.hl7v2.concurrent.BlockingHashMap;
import ca.uhn.hl7v2.concurrent.BlockingMap;
import ca.uhn.hl7v2.concurrent.DefaultExecutorService;
import ca.uhn.hl7v2.llp.HL7Writer;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.llp.LowerLayerProtocol;
import ca.uhn.hl7v2.parser.Parser;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveConnection
implements Connection {
    private static final Logger log = LoggerFactory.getLogger(ActiveConnection.class);
    private Initiator initiator;
    private Responder responder;
    private List<Socket> sockets;
    private HL7Writer ackWriter;
    private HL7Writer sendWriter;
    private Parser parser;
    private BlockingMap<String, String> responses;
    private List<Receiver> receivers;
    private boolean open = true;
    private ExecutorService executorService;

    public ActiveConnection(Parser parser, LowerLayerProtocol llp, Socket bidirectional) throws LLPException, IOException {
        this(parser, llp, bidirectional, DefaultExecutorService.getDefaultService());
    }

    public ActiveConnection(Parser parser, LowerLayerProtocol llp, Socket bidirectional, ExecutorService executorService) throws LLPException, IOException {
        this.init(parser, executorService, bidirectional);
        this.sendWriter = this.ackWriter = llp.getWriter(bidirectional.getOutputStream());
        this.executorService = executorService;
        this.sockets.add(bidirectional);
        this.receivers.add(new Receiver(this, llp.getReader(bidirectional.getInputStream())));
        this.initiator = new ActiveInitiator(this);
    }

    public ActiveConnection(Parser parser, LowerLayerProtocol llp, Socket inbound, Socket outbound) throws LLPException, IOException {
        this(parser, llp, inbound, outbound, DefaultExecutorService.getDefaultService());
    }

    public ActiveConnection(Parser parser, LowerLayerProtocol llp, Socket inbound, Socket outbound, ExecutorService executorService) throws LLPException, IOException {
        this.init(parser, executorService, inbound);
        this.ackWriter = llp.getWriter(inbound.getOutputStream());
        this.sendWriter = llp.getWriter(outbound.getOutputStream());
        this.sockets.add(outbound);
        this.sockets.add(inbound);
        this.receivers.add(new Receiver(this, llp.getReader(inbound.getInputStream())));
        this.receivers.add(new Receiver(this, llp.getReader(outbound.getInputStream())));
        this.initiator = new ActiveInitiator(this);
    }

    private void init(Parser parser, ExecutorService executorService, Socket inboundSocket) throws LLPException {
        this.parser = parser;
        this.executorService = executorService;
        this.sockets = new ArrayList<Socket>();
        this.responses = new BlockingHashMap<String, String>(executorService);
        this.receivers = new ArrayList<Receiver>(2);
        this.responder = new Responder(inboundSocket);
    }

    @Override
    public void activate() {
        if (this.receivers != null) {
            for (Receiver receiver : this.receivers) {
                receiver.start();
            }
        }
    }

    @Override
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public InetAddress getRemoteAddress() {
        Socket s = this.sockets.get(0);
        return s.getInetAddress();
    }

    @Override
    public Integer getRemotePort() {
        Socket s = this.sockets.get(0);
        return s.getPort();
    }

    @Override
    public Initiator getInitiator() {
        return this.initiator;
    }

    public Responder getResponder() {
        return this.responder;
    }

    public boolean isSecure() {
        if (this.isOpen() && this.sockets.size() > 0) {
            return this.sockets.get(0) instanceof SSLSocket;
        }
        throw new IllegalStateException("Can't determine status on closed socket");
    }

    protected HL7Writer getSendWriter() {
        return this.sendWriter;
    }

    protected HL7Writer getAckWriter() {
        return this.ackWriter;
    }

    public Parser getParser() {
        return this.parser;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getRemoteAddress().getHostName());
        buf.append(":");
        Iterator<Socket> iter = this.sockets.iterator();
        while (iter.hasNext()) {
            Socket socket = iter.next();
            buf.append(socket.getPort());
            if (!iter.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    protected Future<String> waitForResponse(String messageID, long timeout) throws InterruptedException {
        return this.responses.asyncPoll(messageID, timeout, TimeUnit.MILLISECONDS);
    }

    protected boolean isRecipientWaiting(String ackID, String message) {
        return this.responses.give(ackID, message);
    }

    @Override
    public void close() {
        for (Receiver receiver : this.receivers) {
            if (!receiver.isRunning()) continue;
            receiver.stop();
        }
        for (Socket socket : this.sockets) {
            try {
                if (socket.isClosed()) continue;
                socket.close();
            }
            catch (Exception e) {
                log.error("Error while stopping threads and closing sockets", (Throwable)e);
            }
        }
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }
}

