/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.app;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.app.Connection;
import ca.uhn.hl7v2.app.ConnectionData;
import ca.uhn.hl7v2.app.ConnectionFactory;
import ca.uhn.hl7v2.app.Initiator;
import ca.uhn.hl7v2.llp.LLPException;
import ca.uhn.hl7v2.model.Message;
import java.io.IOException;
import java.net.InetAddress;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class LazyConnection
implements Connection {
    private ConnectionData data;
    private ExecutorService executor;
    private Connection activeConnection;
    private LazyInitiator initiator;

    public LazyConnection(ConnectionData data, ExecutorService executor) {
        this.data = data;
        this.executor = executor;
        this.initiator = new LazyInitiator(this);
    }

    public void activate() {
        if (this.isEstablished()) {
            this.activeConnection.activate();
        }
    }

    public Initiator getInitiator() {
        if (this.isEstablished()) {
            return this.activeConnection.getInitiator();
        }
        return this.initiator;
    }

    public void close() {
        if (this.isEstablished()) {
            this.activeConnection.close();
            this.activeConnection = null;
        }
    }

    public boolean isOpen() {
        return this.isEstablished() && this.activeConnection.isOpen();
    }

    public ExecutorService getExecutorService() {
        if (this.isEstablished()) {
            return this.activeConnection.getExecutorService();
        }
        return this.executor;
    }

    public InetAddress getRemoteAddress() {
        if (this.isEstablished()) {
            return this.activeConnection.getRemoteAddress();
        }
        return null;
    }

    public Integer getRemotePort() {
        if (this.isEstablished()) {
            return this.activeConnection.getRemotePort();
        }
        return null;
    }

    boolean isEstablished() {
        return this.activeConnection != null && this.activeConnection.isOpen();
    }

    void establishConnection() throws HL7Exception {
        try {
            this.activeConnection = ConnectionFactory.openEagerly(this.data, this.executor);
        }
        catch (Exception e) {
            throw new HL7Exception(e);
        }
    }

    class LazyInitiator
    implements Initiator {
        private LazyConnection connection;
        private long timeoutMillis = 10000L;

        LazyInitiator(LazyConnection connection) {
            this.connection = connection;
        }

        public synchronized Message sendAndReceive(Message out) throws HL7Exception, LLPException, IOException {
            if (!this.connection.isEstablished()) {
                this.connection.establishConnection();
                this.setTimeout(this.timeoutMillis, TimeUnit.MILLISECONDS);
            }
            return this.connection.getInitiator().sendAndReceive(out);
        }

        public synchronized void setTimeout(long timeout, TimeUnit timeunit) {
            if (this.connection.isEstablished()) {
                this.connection.getInitiator().setTimeout(timeout, timeunit);
            } else {
                this.timeoutMillis = timeunit.toMillis(timeout);
            }
        }

        public void setTimeoutMillis(int timeout) {
            this.setTimeout(timeout, TimeUnit.MILLISECONDS);
        }
    }
}

