/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.llp;

import ca.uhn.hl7v2.parser.EncodingNotSupportedException;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum HL7Charsets {
    ASCII("ASCII", "US-ASCII"),
    ISO_8859_1("8859/1", "ISO-8859-1"),
    ISO_8859_2("8859/2", "ISO-8859-2"),
    ISO_8859_3("8859/3", "ISO-8859-3"),
    ISO_8859_4("8859/4", "ISO-8859-4"),
    ISO_8859_5("8859/5", "ISO-8859-5"),
    ISO_8859_6("8859/6", "ISO-8859-6"),
    ISO_8859_7("8859/7", "ISO-8859-7"),
    ISO_8859_8("8859/8", "ISO-8859-8"),
    ISO_8859_9("8859/9", "ISO-8859-9"),
    ISO_8859_15("8859/15", "ISO-8859-15"),
    ISO_IR_6("ISO IR6", "US-ASCII"),
    ISO_IR_14("ISO IR14", "JIS_X0201"),
    ISO_IR_87("ISO IR87", "x-JIS0208"),
    ISO_IR_159("ISO IR159", "JIS_X0212-1990"),
    GB_18030("GB 18030-2000", "GB18030"),
    KS_X_1001("KS X 1001", "EUC-KR"),
    CNS_11643("CNS 11643-1992", "x-EUC-TW"),
    BIG_5("BIG-5", "Big5"),
    UNICODE("UNICODE", "UTF-8"),
    UTF_8("UNICODE UTF-8", "UTF-8"),
    UTF_16("UNICODE UTF-16", "UTF-16"),
    UTF_32("UNICODE UTF-32", "UTF-32");

    private String hl7EncodingName;
    private Charset charset;

    private HL7Charsets(String hl7EncodingName, String charset) {
        this.hl7EncodingName = hl7EncodingName;
        this.charset = Charset.forName(charset);
    }

    public static Charset getCharsetForHL7Encoding(String hl7EncodingName) throws EncodingNotSupportedException {
        if (hl7EncodingName == null || hl7EncodingName.length() == 0) {
            return HL7Charsets.ASCII.charset;
        }
        for (HL7Charsets encoding : HL7Charsets.values()) {
            if (!hl7EncodingName.equals(encoding.hl7EncodingName)) continue;
            return encoding.charset;
        }
        throw new EncodingNotSupportedException(hl7EncodingName);
    }

    public static void main(String[] params) {
        for (HL7Charsets entry : HL7Charsets.values()) {
            Charset cs = entry.charset;
            System.out.print(cs.displayName());
            for (String alias : cs.aliases()) {
                System.out.print(" " + alias);
            }
            System.out.println();
        }
    }
}

