/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.AD;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_AUI;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.DT;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.PN;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TN;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class IN1
extends AbstractSegment {
    public IN1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - insurance");
            this.add(ID.class, true, 1, 8, new Object[]{this.getMessage(), new Integer(72)}, "Insurance plan ID");
            this.add(ST.class, true, 1, 9, new Object[]{this.getMessage()}, "Insurance company ID");
            this.add(ST.class, false, 1, 45, new Object[]{this.getMessage()}, "Insurance company name");
            this.add(AD.class, false, 1, 106, new Object[]{this.getMessage()}, "Insurance company address");
            this.add(PN.class, false, 1, 48, new Object[]{this.getMessage()}, "Insurance company contact pers");
            this.add(TN.class, false, 3, 40, new Object[]{this.getMessage()}, "Insurance company phone number");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage()}, "Group number");
            this.add(ST.class, false, 1, 35, new Object[]{this.getMessage()}, "Group name");
            this.add(ST.class, false, 1, 12, new Object[]{this.getMessage()}, "Insured's group employer ID");
            this.add(ST.class, false, 1, 45, new Object[]{this.getMessage()}, "Insured's group employer name");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Plan effective date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Plan expiration date");
            this.add(CM_AUI.class, false, 1, 55, new Object[]{this.getMessage()}, "Authorization information");
            this.add(ID.class, false, 1, 5, new Object[]{this.getMessage(), new Integer(86)}, "Plan type");
            this.add(PN.class, false, 1, 48, new Object[]{this.getMessage()}, "Name of insured");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(63)}, "Insured's relationship to patient");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Insured's date of birth");
            this.add(AD.class, false, 1, 106, new Object[]{this.getMessage()}, "Insured's address");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(135)}, "Assignment of benefits");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(173)}, "Coordination of benefits");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage()}, "Coordination of benefits - priority");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(136)}, "Notice of admission code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Notice of admission date");
            this.add(ID.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(0)}, "Report of eligibility code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Report of eligibility date");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(93)}, "Release information code");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage()}, "Pre-admit certification (PAC)");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Verification date / time");
            this.add(CN.class, false, 1, 60, new Object[]{this.getMessage()}, "Verification by");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(98)}, "Type of agreement code");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(22)}, "Billing status");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Lifetime reserve days");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Delay before lifetime reserve days");
            this.add(ID.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(42)}, "Company plan code");
            this.add(ST.class, false, 1, 15, new Object[]{this.getMessage()}, "Policy number");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Policy deductible");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Policy limit - amount");
            this.add(NM.class, false, 1, 4, new Object[]{this.getMessage()}, "Policy limit - days");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Room rate - semi-private");
            this.add(NM.class, false, 1, 12, new Object[]{this.getMessage()}, "Room rate - private");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Insured's employment status");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Insured's sex");
            this.add(AD.class, false, 1, 106, new Object[]{this.getMessage()}, "Insured's employer address");
            this.add(ST.class, false, 1, 2, new Object[]{this.getMessage()}, "Verification status");
            this.add(ID.class, false, 1, 8, new Object[]{this.getMessage(), new Integer(72)}, "Prior insurance plan ID");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating IN1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDInsurance() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getIn11_SetIDInsurance() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getInsurancePlanID() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getIn12_InsurancePlanID() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ST getInsuranceCompanyID() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getIn13_InsuranceCompanyID() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getInsuranceCompanyName() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getIn14_InsuranceCompanyName() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public AD getInsuranceCompanyAddress() {
        AD retVal = (AD)this.getTypedField(5, 0);
        return retVal;
    }

    public AD getIn15_InsuranceCompanyAddress() {
        AD retVal = (AD)this.getTypedField(5, 0);
        return retVal;
    }

    public PN getInsuranceCompanyContactPers() {
        PN retVal = (PN)this.getTypedField(6, 0);
        return retVal;
    }

    public PN getIn16_InsuranceCompanyContactPers() {
        PN retVal = (PN)this.getTypedField(6, 0);
        return retVal;
    }

    public TN[] getInsuranceCompanyPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(7, new TN[0]);
        return retVal;
    }

    public TN[] getIn17_InsuranceCompanyPhoneNumber() {
        TN[] retVal = (TN[])this.getTypedField(7, new TN[0]);
        return retVal;
    }

    public int getInsuranceCompanyPhoneNumberReps() {
        return this.getReps(7);
    }

    public TN getInsuranceCompanyPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(7, rep);
        return retVal;
    }

    public TN getIn17_InsuranceCompanyPhoneNumber(int rep) {
        TN retVal = (TN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getIn17_InsuranceCompanyPhoneNumberReps() {
        return this.getReps(7);
    }

    public TN insertInsuranceCompanyPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(7, rep);
    }

    public TN insertIn17_InsuranceCompanyPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.insertRepetition(7, rep);
    }

    public TN removeInsuranceCompanyPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(7, rep);
    }

    public TN removeIn17_InsuranceCompanyPhoneNumber(int rep) throws HL7Exception {
        return (TN)super.removeRepetition(7, rep);
    }

    public ST getGroupNumber() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getIn18_GroupNumber() {
        ST retVal = (ST)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getGroupName() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getIn19_GroupName() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getInsuredSGroupEmployerID() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getIn110_InsuredSGroupEmployerID() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getInsuredSGroupEmployerName() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getIn111_InsuredSGroupEmployerName() {
        ST retVal = (ST)this.getTypedField(11, 0);
        return retVal;
    }

    public DT getPlanEffectiveDate() {
        DT retVal = (DT)this.getTypedField(12, 0);
        return retVal;
    }

    public DT getIn112_PlanEffectiveDate() {
        DT retVal = (DT)this.getTypedField(12, 0);
        return retVal;
    }

    public DT getPlanExpirationDate() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getIn113_PlanExpirationDate() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public CM_AUI getAuthorizationInformation() {
        CM_AUI retVal = (CM_AUI)this.getTypedField(14, 0);
        return retVal;
    }

    public CM_AUI getIn114_AuthorizationInformation() {
        CM_AUI retVal = (CM_AUI)this.getTypedField(14, 0);
        return retVal;
    }

    public ID getPlanType() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public ID getIn115_PlanType() {
        ID retVal = (ID)this.getTypedField(15, 0);
        return retVal;
    }

    public PN getNameOfInsured() {
        PN retVal = (PN)this.getTypedField(16, 0);
        return retVal;
    }

    public PN getIn116_NameOfInsured() {
        PN retVal = (PN)this.getTypedField(16, 0);
        return retVal;
    }

    public ID getInsuredSRelationshipToPatient() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getIn117_InsuredSRelationshipToPatient() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public DT getInsuredSDateOfBirth() {
        DT retVal = (DT)this.getTypedField(18, 0);
        return retVal;
    }

    public DT getIn118_InsuredSDateOfBirth() {
        DT retVal = (DT)this.getTypedField(18, 0);
        return retVal;
    }

    public AD getInsuredSAddress() {
        AD retVal = (AD)this.getTypedField(19, 0);
        return retVal;
    }

    public AD getIn119_InsuredSAddress() {
        AD retVal = (AD)this.getTypedField(19, 0);
        return retVal;
    }

    public ID getAssignmentOfBenefits() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getIn120_AssignmentOfBenefits() {
        ID retVal = (ID)this.getTypedField(20, 0);
        return retVal;
    }

    public ID getCoordinationOfBenefits() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ID getIn121_CoordinationOfBenefits() {
        ID retVal = (ID)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getCoordinationOfBenefitsPriority() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getIn122_CoordinationOfBenefitsPriority() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getNoticeOfAdmissionCode() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public ID getIn123_NoticeOfAdmissionCode() {
        ID retVal = (ID)this.getTypedField(23, 0);
        return retVal;
    }

    public DT getNoticeOfAdmissionDate() {
        DT retVal = (DT)this.getTypedField(24, 0);
        return retVal;
    }

    public DT getIn124_NoticeOfAdmissionDate() {
        DT retVal = (DT)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getReportOfEligibilityCode() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getIn125_ReportOfEligibilityCode() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public DT getReportOfEligibilityDate() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    public DT getIn126_ReportOfEligibilityDate() {
        DT retVal = (DT)this.getTypedField(26, 0);
        return retVal;
    }

    public ID getReleaseInformationCode() {
        ID retVal = (ID)this.getTypedField(27, 0);
        return retVal;
    }

    public ID getIn127_ReleaseInformationCode() {
        ID retVal = (ID)this.getTypedField(27, 0);
        return retVal;
    }

    public ST getPreAdmitCertification() {
        ST retVal = (ST)this.getTypedField(28, 0);
        return retVal;
    }

    public ST getIn128_PreAdmitCertification() {
        ST retVal = (ST)this.getTypedField(28, 0);
        return retVal;
    }

    public TS getVerificationDateTime() {
        TS retVal = (TS)this.getTypedField(29, 0);
        return retVal;
    }

    public TS getIn129_VerificationDateTime() {
        TS retVal = (TS)this.getTypedField(29, 0);
        return retVal;
    }

    public CN getVerificationBy() {
        CN retVal = (CN)this.getTypedField(30, 0);
        return retVal;
    }

    public CN getIn130_VerificationBy() {
        CN retVal = (CN)this.getTypedField(30, 0);
        return retVal;
    }

    public ID getTypeOfAgreementCode() {
        ID retVal = (ID)this.getTypedField(31, 0);
        return retVal;
    }

    public ID getIn131_TypeOfAgreementCode() {
        ID retVal = (ID)this.getTypedField(31, 0);
        return retVal;
    }

    public ID getBillingStatus() {
        ID retVal = (ID)this.getTypedField(32, 0);
        return retVal;
    }

    public ID getIn132_BillingStatus() {
        ID retVal = (ID)this.getTypedField(32, 0);
        return retVal;
    }

    public NM getLifetimeReserveDays() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getIn133_LifetimeReserveDays() {
        NM retVal = (NM)this.getTypedField(33, 0);
        return retVal;
    }

    public NM getDelayBeforeLifetimeReserveDays() {
        NM retVal = (NM)this.getTypedField(34, 0);
        return retVal;
    }

    public NM getIn134_DelayBeforeLifetimeReserveDays() {
        NM retVal = (NM)this.getTypedField(34, 0);
        return retVal;
    }

    public ID getCompanyPlanCode() {
        ID retVal = (ID)this.getTypedField(35, 0);
        return retVal;
    }

    public ID getIn135_CompanyPlanCode() {
        ID retVal = (ID)this.getTypedField(35, 0);
        return retVal;
    }

    public ST getPolicyNumber() {
        ST retVal = (ST)this.getTypedField(36, 0);
        return retVal;
    }

    public ST getIn136_PolicyNumber() {
        ST retVal = (ST)this.getTypedField(36, 0);
        return retVal;
    }

    public NM getPolicyDeductible() {
        NM retVal = (NM)this.getTypedField(37, 0);
        return retVal;
    }

    public NM getIn137_PolicyDeductible() {
        NM retVal = (NM)this.getTypedField(37, 0);
        return retVal;
    }

    public NM getPolicyLimitAmount() {
        NM retVal = (NM)this.getTypedField(38, 0);
        return retVal;
    }

    public NM getIn138_PolicyLimitAmount() {
        NM retVal = (NM)this.getTypedField(38, 0);
        return retVal;
    }

    public NM getPolicyLimitDays() {
        NM retVal = (NM)this.getTypedField(39, 0);
        return retVal;
    }

    public NM getIn139_PolicyLimitDays() {
        NM retVal = (NM)this.getTypedField(39, 0);
        return retVal;
    }

    public NM getRoomRateSemiPrivate() {
        NM retVal = (NM)this.getTypedField(40, 0);
        return retVal;
    }

    public NM getIn140_RoomRateSemiPrivate() {
        NM retVal = (NM)this.getTypedField(40, 0);
        return retVal;
    }

    public NM getRoomRatePrivate() {
        NM retVal = (NM)this.getTypedField(41, 0);
        return retVal;
    }

    public NM getIn141_RoomRatePrivate() {
        NM retVal = (NM)this.getTypedField(41, 0);
        return retVal;
    }

    public CE getInsuredSEmploymentStatus() {
        CE retVal = (CE)this.getTypedField(42, 0);
        return retVal;
    }

    public CE getIn142_InsuredSEmploymentStatus() {
        CE retVal = (CE)this.getTypedField(42, 0);
        return retVal;
    }

    public ID getInsuredSSex() {
        ID retVal = (ID)this.getTypedField(43, 0);
        return retVal;
    }

    public ID getIn143_InsuredSSex() {
        ID retVal = (ID)this.getTypedField(43, 0);
        return retVal;
    }

    public AD getInsuredSEmployerAddress() {
        AD retVal = (AD)this.getTypedField(44, 0);
        return retVal;
    }

    public AD getIn144_InsuredSEmployerAddress() {
        AD retVal = (AD)this.getTypedField(44, 0);
        return retVal;
    }

    public ST getVerificationStatus() {
        ST retVal = (ST)this.getTypedField(45, 0);
        return retVal;
    }

    public ST getIn145_VerificationStatus() {
        ST retVal = (ST)this.getTypedField(45, 0);
        return retVal;
    }

    public ID getPriorInsurancePlanID() {
        ID retVal = (ID)this.getTypedField(46, 0);
        return retVal;
    }

    public ID getIn146_PriorInsurancePlanID() {
        ID retVal = (ID)this.getTypedField(46, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(72));
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new AD(this.getMessage());
            }
            case 5: {
                return new PN(this.getMessage());
            }
            case 6: {
                return new TN(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new ST(this.getMessage());
            }
            case 11: {
                return new DT(this.getMessage());
            }
            case 12: {
                return new DT(this.getMessage());
            }
            case 13: {
                return new CM_AUI(this.getMessage());
            }
            case 14: {
                return new ID(this.getMessage(), new Integer(86));
            }
            case 15: {
                return new PN(this.getMessage());
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(63));
            }
            case 17: {
                return new DT(this.getMessage());
            }
            case 18: {
                return new AD(this.getMessage());
            }
            case 19: {
                return new ID(this.getMessage(), new Integer(135));
            }
            case 20: {
                return new ID(this.getMessage(), new Integer(173));
            }
            case 21: {
                return new ST(this.getMessage());
            }
            case 22: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 23: {
                return new DT(this.getMessage());
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 25: {
                return new DT(this.getMessage());
            }
            case 26: {
                return new ID(this.getMessage(), new Integer(93));
            }
            case 27: {
                return new ST(this.getMessage());
            }
            case 28: {
                return new TS(this.getMessage());
            }
            case 29: {
                return new CN(this.getMessage());
            }
            case 30: {
                return new ID(this.getMessage(), new Integer(98));
            }
            case 31: {
                return new ID(this.getMessage(), new Integer(22));
            }
            case 32: {
                return new NM(this.getMessage());
            }
            case 33: {
                return new NM(this.getMessage());
            }
            case 34: {
                return new ID(this.getMessage(), new Integer(42));
            }
            case 35: {
                return new ST(this.getMessage());
            }
            case 36: {
                return new NM(this.getMessage());
            }
            case 37: {
                return new NM(this.getMessage());
            }
            case 38: {
                return new NM(this.getMessage());
            }
            case 39: {
                return new NM(this.getMessage());
            }
            case 40: {
                return new NM(this.getMessage());
            }
            case 41: {
                return new CE(this.getMessage());
            }
            case 42: {
                return new ID(this.getMessage(), new Integer(1));
            }
            case 43: {
                return new AD(this.getMessage());
            }
            case 44: {
                return new ST(this.getMessage());
            }
            case 45: {
                return new ID(this.getMessage(), new Integer(72));
            }
        }
        return null;
    }
}

