/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class URD
extends AbstractSegment {
    public URD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "R/U date / time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(109)}, "Report Priority");
            this.add(ST.class, true, 0, 20, new Object[]{this.getMessage()}, "R/U Who Subject Definition");
            this.add(ID.class, false, 0, 3, new Object[]{this.getMessage(), new Integer(48)}, "R/U What Subject Definition");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "R/U What Department Code");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "R/U display / print locations");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(108)}, "R/U Results Level");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating URD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public TS getRUDateTime() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getUrd1_RUDateTime() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getReportPriority() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getUrd2_ReportPriority() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ST[] getRUWhoSubjectDefinition() {
        ST[] retVal = (ST[])this.getTypedField(3, new ST[0]);
        return retVal;
    }

    public ST[] getUrd3_RUWhoSubjectDefinition() {
        ST[] retVal = (ST[])this.getTypedField(3, new ST[0]);
        return retVal;
    }

    public int getRUWhoSubjectDefinitionReps() {
        return this.getReps(3);
    }

    public ST getRUWhoSubjectDefinition(int rep) {
        ST retVal = (ST)this.getTypedField(3, rep);
        return retVal;
    }

    public ST getUrd3_RUWhoSubjectDefinition(int rep) {
        ST retVal = (ST)this.getTypedField(3, rep);
        return retVal;
    }

    public int getUrd3_RUWhoSubjectDefinitionReps() {
        return this.getReps(3);
    }

    public ST insertRUWhoSubjectDefinition(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(3, rep);
    }

    public ST insertUrd3_RUWhoSubjectDefinition(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(3, rep);
    }

    public ST removeRUWhoSubjectDefinition(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(3, rep);
    }

    public ST removeUrd3_RUWhoSubjectDefinition(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(3, rep);
    }

    public ID[] getRUWhatSubjectDefinition() {
        ID[] retVal = (ID[])this.getTypedField(4, new ID[0]);
        return retVal;
    }

    public ID[] getUrd4_RUWhatSubjectDefinition() {
        ID[] retVal = (ID[])this.getTypedField(4, new ID[0]);
        return retVal;
    }

    public int getRUWhatSubjectDefinitionReps() {
        return this.getReps(4);
    }

    public ID getRUWhatSubjectDefinition(int rep) {
        ID retVal = (ID)this.getTypedField(4, rep);
        return retVal;
    }

    public ID getUrd4_RUWhatSubjectDefinition(int rep) {
        ID retVal = (ID)this.getTypedField(4, rep);
        return retVal;
    }

    public int getUrd4_RUWhatSubjectDefinitionReps() {
        return this.getReps(4);
    }

    public ID insertRUWhatSubjectDefinition(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(4, rep);
    }

    public ID insertUrd4_RUWhatSubjectDefinition(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(4, rep);
    }

    public ID removeRUWhatSubjectDefinition(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(4, rep);
    }

    public ID removeUrd4_RUWhatSubjectDefinition(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(4, rep);
    }

    public ST[] getRUWhatDepartmentCode() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public ST[] getUrd5_RUWhatDepartmentCode() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public int getRUWhatDepartmentCodeReps() {
        return this.getReps(5);
    }

    public ST getRUWhatDepartmentCode(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getUrd5_RUWhatDepartmentCode(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getUrd5_RUWhatDepartmentCodeReps() {
        return this.getReps(5);
    }

    public ST insertRUWhatDepartmentCode(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertUrd5_RUWhatDepartmentCode(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removeRUWhatDepartmentCode(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removeUrd5_RUWhatDepartmentCode(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST[] getRUDisplayPrintLocations() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public ST[] getUrd6_RUDisplayPrintLocations() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public int getRUDisplayPrintLocationsReps() {
        return this.getReps(6);
    }

    public ST getRUDisplayPrintLocations(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getUrd6_RUDisplayPrintLocations(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getUrd6_RUDisplayPrintLocationsReps() {
        return this.getReps(6);
    }

    public ST insertRUDisplayPrintLocations(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertUrd6_RUDisplayPrintLocations(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeRUDisplayPrintLocations(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removeUrd6_RUDisplayPrintLocations(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ID getRUResultsLevel() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    public ID getUrd7_RUResultsLevel() {
        ID retVal = (ID)this.getTypedField(7, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new TS(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(109));
            }
            case 2: {
                return new ST(this.getMessage());
            }
            case 3: {
                return new ID(this.getMessage(), new Integer(48));
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(108));
            }
        }
        return null;
    }
}

