/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.segment.CTD;
import ca.uhn.hl7v2.model.v23.segment.PRD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPA_I10_PROVIDER
extends AbstractGroup {
    public RPA_I10_PROVIDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(PRD.class, true, false, false);
            this.add(CTD.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RPA_I10_PROVIDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public PRD getPRD() {
        PRD retVal = this.getTyped("PRD", PRD.class);
        return retVal;
    }

    public CTD getCTD() {
        CTD retVal = this.getTyped("CTD", CTD.class);
        return retVal;
    }

    public CTD getCTD(int rep) {
        CTD retVal = this.getTyped("CTD", rep, CTD.class);
        return retVal;
    }

    public int getCTDReps() {
        return this.getReps("CTD");
    }

    public List<CTD> getCTDAll() throws HL7Exception {
        return this.getAllAsList("CTD", CTD.class);
    }

    public void insertCTD(CTD structure, int rep) throws HL7Exception {
        super.insertRepetition("CTD", structure, rep);
    }

    public CTD insertCTD(int rep) throws HL7Exception {
        return (CTD)super.insertRepetition("CTD", rep);
    }

    public CTD removeCTD(int rep) throws HL7Exception {
        return (CTD)super.removeRepetition("CTD", rep);
    }
}

