/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.EI;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.XAD;
import ca.uhn.hl7v2.model.v23.datatype.XCN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class FAC
extends AbstractSegment {
    public FAC(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 0, 60, new Object[]{this.getMessage()}, "Facility ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(331)}, "Facility Type");
            this.add(XAD.class, true, 1, 200, new Object[]{this.getMessage()}, "Facility Address");
            this.add(XTN.class, true, 1, 44, new Object[]{this.getMessage()}, "Facility Telecommunication");
            this.add(XCN.class, false, 0, 60, new Object[]{this.getMessage()}, "Contact Person");
            this.add(ST.class, false, 0, 60, new Object[]{this.getMessage()}, "Contact Title");
            this.add(XAD.class, false, 0, 60, new Object[]{this.getMessage()}, "Contact Address");
            this.add(XTN.class, false, 0, 44, new Object[]{this.getMessage()}, "Contact Telecommunication");
            this.add(XCN.class, true, 1, 60, new Object[]{this.getMessage()}, "Signature Authority");
            this.add(ST.class, false, 1, 60, new Object[]{this.getMessage()}, "Signature Authority Title");
            this.add(XAD.class, false, 1, 200, new Object[]{this.getMessage()}, "Signature Authority Address");
            this.add(XTN.class, false, 1, 44, new Object[]{this.getMessage()}, "Signature Authority Telecommunication");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating FAC - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI[] getFacilityID() {
        EI[] retVal = (EI[])this.getTypedField(1, new EI[0]);
        return retVal;
    }

    public EI[] getFac1_FacilityID() {
        EI[] retVal = (EI[])this.getTypedField(1, new EI[0]);
        return retVal;
    }

    public int getFacilityIDReps() {
        return this.getReps(1);
    }

    public EI getFacilityID(int rep) {
        EI retVal = (EI)this.getTypedField(1, rep);
        return retVal;
    }

    public EI getFac1_FacilityID(int rep) {
        EI retVal = (EI)this.getTypedField(1, rep);
        return retVal;
    }

    public int getFac1_FacilityIDReps() {
        return this.getReps(1);
    }

    public EI insertFacilityID(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(1, rep);
    }

    public EI insertFac1_FacilityID(int rep) throws HL7Exception {
        return (EI)super.insertRepetition(1, rep);
    }

    public EI removeFacilityID(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(1, rep);
    }

    public EI removeFac1_FacilityID(int rep) throws HL7Exception {
        return (EI)super.removeRepetition(1, rep);
    }

    public ID getFacilityType() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getFac2_FacilityType() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public XAD getFacilityAddress() {
        XAD retVal = (XAD)this.getTypedField(3, 0);
        return retVal;
    }

    public XAD getFac3_FacilityAddress() {
        XAD retVal = (XAD)this.getTypedField(3, 0);
        return retVal;
    }

    public XTN getFacilityTelecommunication() {
        XTN retVal = (XTN)this.getTypedField(4, 0);
        return retVal;
    }

    public XTN getFac4_FacilityTelecommunication() {
        XTN retVal = (XTN)this.getTypedField(4, 0);
        return retVal;
    }

    public XCN[] getContactPerson() {
        XCN[] retVal = (XCN[])this.getTypedField(5, new XCN[0]);
        return retVal;
    }

    public XCN[] getFac5_ContactPerson() {
        XCN[] retVal = (XCN[])this.getTypedField(5, new XCN[0]);
        return retVal;
    }

    public int getContactPersonReps() {
        return this.getReps(5);
    }

    public XCN getContactPerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(5, rep);
        return retVal;
    }

    public XCN getFac5_ContactPerson(int rep) {
        XCN retVal = (XCN)this.getTypedField(5, rep);
        return retVal;
    }

    public int getFac5_ContactPersonReps() {
        return this.getReps(5);
    }

    public XCN insertContactPerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN insertFac5_ContactPerson(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(5, rep);
    }

    public XCN removeContactPerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public XCN removeFac5_ContactPerson(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(5, rep);
    }

    public ST[] getContactTitle() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public ST[] getFac6_ContactTitle() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public int getContactTitleReps() {
        return this.getReps(6);
    }

    public ST getContactTitle(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getFac6_ContactTitle(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getFac6_ContactTitleReps() {
        return this.getReps(6);
    }

    public ST insertContactTitle(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertFac6_ContactTitle(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeContactTitle(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removeFac6_ContactTitle(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public XAD[] getContactAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(7, new XAD[0]);
        return retVal;
    }

    public XAD[] getFac7_ContactAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(7, new XAD[0]);
        return retVal;
    }

    public int getContactAddressReps() {
        return this.getReps(7);
    }

    public XAD getContactAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(7, rep);
        return retVal;
    }

    public XAD getFac7_ContactAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(7, rep);
        return retVal;
    }

    public int getFac7_ContactAddressReps() {
        return this.getReps(7);
    }

    public XAD insertContactAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(7, rep);
    }

    public XAD insertFac7_ContactAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(7, rep);
    }

    public XAD removeContactAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(7, rep);
    }

    public XAD removeFac7_ContactAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(7, rep);
    }

    public XTN[] getContactTelecommunication() {
        XTN[] retVal = (XTN[])this.getTypedField(8, new XTN[0]);
        return retVal;
    }

    public XTN[] getFac8_ContactTelecommunication() {
        XTN[] retVal = (XTN[])this.getTypedField(8, new XTN[0]);
        return retVal;
    }

    public int getContactTelecommunicationReps() {
        return this.getReps(8);
    }

    public XTN getContactTelecommunication(int rep) {
        XTN retVal = (XTN)this.getTypedField(8, rep);
        return retVal;
    }

    public XTN getFac8_ContactTelecommunication(int rep) {
        XTN retVal = (XTN)this.getTypedField(8, rep);
        return retVal;
    }

    public int getFac8_ContactTelecommunicationReps() {
        return this.getReps(8);
    }

    public XTN insertContactTelecommunication(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(8, rep);
    }

    public XTN insertFac8_ContactTelecommunication(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(8, rep);
    }

    public XTN removeContactTelecommunication(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(8, rep);
    }

    public XTN removeFac8_ContactTelecommunication(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(8, rep);
    }

    public XCN getSignatureAuthority() {
        XCN retVal = (XCN)this.getTypedField(9, 0);
        return retVal;
    }

    public XCN getFac9_SignatureAuthority() {
        XCN retVal = (XCN)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getSignatureAuthorityTitle() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public ST getFac10_SignatureAuthorityTitle() {
        ST retVal = (ST)this.getTypedField(10, 0);
        return retVal;
    }

    public XAD getSignatureAuthorityAddress() {
        XAD retVal = (XAD)this.getTypedField(11, 0);
        return retVal;
    }

    public XAD getFac11_SignatureAuthorityAddress() {
        XAD retVal = (XAD)this.getTypedField(11, 0);
        return retVal;
    }

    public XTN getSignatureAuthorityTelecommunication() {
        XTN retVal = (XTN)this.getTypedField(12, 0);
        return retVal;
    }

    public XTN getFac12_SignatureAuthorityTelecommunication() {
        XTN retVal = (XTN)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(331));
            }
            case 2: {
                return new XAD(this.getMessage());
            }
            case 3: {
                return new XTN(this.getMessage());
            }
            case 4: {
                return new XCN(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
            case 6: {
                return new XAD(this.getMessage());
            }
            case 7: {
                return new XTN(this.getMessage());
            }
            case 8: {
                return new XCN(this.getMessage());
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new XAD(this.getMessage());
            }
            case 11: {
                return new XTN(this.getMessage());
            }
        }
        return null;
    }
}

