/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.EI;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TS;
import ca.uhn.hl7v2.model.v24.datatype.XCN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class VAR
extends AbstractSegment {
    public VAR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(EI.class, true, 1, 60, new Object[]{this.getMessage()}, "Variance Instance ID");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Documented Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Stated Variance Date/Time");
            this.add(XCN.class, false, 0, 250, new Object[]{this.getMessage()}, "Variance Originator");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Variance Classification");
            this.add(ST.class, false, 0, 512, new Object[]{this.getMessage()}, "Variance Description");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating VAR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public EI getVarianceInstanceID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getVar1_VarianceInstanceID() {
        EI retVal = (EI)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getDocumentedDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getVar2_DocumentedDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getStatedVarianceDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getVar3_StatedVarianceDateTime() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public XCN[] getVarianceOriginator() {
        XCN[] retVal = (XCN[])this.getTypedField(4, new XCN[0]);
        return retVal;
    }

    public XCN[] getVar4_VarianceOriginator() {
        XCN[] retVal = (XCN[])this.getTypedField(4, new XCN[0]);
        return retVal;
    }

    public int getVarianceOriginatorReps() {
        return this.getReps(4);
    }

    public XCN getVarianceOriginator(int rep) {
        XCN retVal = (XCN)this.getTypedField(4, rep);
        return retVal;
    }

    public XCN getVar4_VarianceOriginator(int rep) {
        XCN retVal = (XCN)this.getTypedField(4, rep);
        return retVal;
    }

    public int getVar4_VarianceOriginatorReps() {
        return this.getReps(4);
    }

    public XCN insertVarianceOriginator(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(4, rep);
    }

    public XCN insertVar4_VarianceOriginator(int rep) throws HL7Exception {
        return (XCN)super.insertRepetition(4, rep);
    }

    public XCN removeVarianceOriginator(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(4, rep);
    }

    public XCN removeVar4_VarianceOriginator(int rep) throws HL7Exception {
        return (XCN)super.removeRepetition(4, rep);
    }

    public CE getVarianceClassification() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getVar5_VarianceClassification() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public ST[] getVarianceDescription() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public ST[] getVar6_VarianceDescription() {
        ST[] retVal = (ST[])this.getTypedField(6, new ST[0]);
        return retVal;
    }

    public int getVarianceDescriptionReps() {
        return this.getReps(6);
    }

    public ST getVarianceDescription(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public ST getVar6_VarianceDescription(int rep) {
        ST retVal = (ST)this.getTypedField(6, rep);
        return retVal;
    }

    public int getVar6_VarianceDescriptionReps() {
        return this.getReps(6);
    }

    public ST insertVarianceDescription(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST insertVar6_VarianceDescription(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(6, rep);
    }

    public ST removeVarianceDescription(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    public ST removeVar6_VarianceDescription(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(6, rep);
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new EI(this.getMessage());
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new XCN(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

