/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v25.group.MFR_M06_MF_QUERY;
import ca.uhn.hl7v2.model.v25.segment.DSC;
import ca.uhn.hl7v2.model.v25.segment.ERR;
import ca.uhn.hl7v2.model.v25.segment.MFI;
import ca.uhn.hl7v2.model.v25.segment.MSA;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.QAK;
import ca.uhn.hl7v2.model.v25.segment.QRD;
import ca.uhn.hl7v2.model.v25.segment.QRF;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFR_M06
extends AbstractMessage {
    public MFR_M06() {
        this(new DefaultModelClassFactory());
    }

    public MFR_M06(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(MSA.class, true, false);
            this.add(ERR.class, false, true);
            this.add(QAK.class, false, false);
            this.add(QRD.class, true, false);
            this.add(QRF.class, false, false);
            this.add(MFI.class, true, false);
            this.add(MFR_M06_MF_QUERY.class, true, true);
            this.add(DSC.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFR_M06 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public MSA getMSA() {
        return this.getTyped("MSA", MSA.class);
    }

    public ERR getERR() {
        return this.getTyped("ERR", ERR.class);
    }

    public ERR getERR(int rep) {
        return this.getTyped("ERR", rep, ERR.class);
    }

    public int getERRReps() {
        return this.getReps("ERR");
    }

    public List<ERR> getERRAll() throws HL7Exception {
        return this.getAllAsList("ERR", ERR.class);
    }

    public void insertERR(ERR structure, int rep) throws HL7Exception {
        super.insertRepetition("ERR", structure, rep);
    }

    public ERR insertERR(int rep) throws HL7Exception {
        return (ERR)super.insertRepetition("ERR", rep);
    }

    public ERR removeERR(int rep) throws HL7Exception {
        return (ERR)super.removeRepetition("ERR", rep);
    }

    public QAK getQAK() {
        return this.getTyped("QAK", QAK.class);
    }

    public QRD getQRD() {
        return this.getTyped("QRD", QRD.class);
    }

    public QRF getQRF() {
        return this.getTyped("QRF", QRF.class);
    }

    public MFI getMFI() {
        return this.getTyped("MFI", MFI.class);
    }

    public MFR_M06_MF_QUERY getMF_QUERY() {
        return this.getTyped("MF_QUERY", MFR_M06_MF_QUERY.class);
    }

    public MFR_M06_MF_QUERY getMF_QUERY(int rep) {
        return this.getTyped("MF_QUERY", rep, MFR_M06_MF_QUERY.class);
    }

    public int getMF_QUERYReps() {
        return this.getReps("MF_QUERY");
    }

    public List<MFR_M06_MF_QUERY> getMF_QUERYAll() throws HL7Exception {
        return this.getAllAsList("MF_QUERY", MFR_M06_MF_QUERY.class);
    }

    public void insertMF_QUERY(MFR_M06_MF_QUERY structure, int rep) throws HL7Exception {
        super.insertRepetition("MF_QUERY", structure, rep);
    }

    public MFR_M06_MF_QUERY insertMF_QUERY(int rep) throws HL7Exception {
        return (MFR_M06_MF_QUERY)super.insertRepetition("MF_QUERY", rep);
    }

    public MFR_M06_MF_QUERY removeMF_QUERY(int rep) throws HL7Exception {
        return (MFR_M06_MF_QUERY)super.removeRepetition("MF_QUERY", rep);
    }

    public DSC getDSC() {
        return this.getTyped("DSC", DSC.class);
    }
}

