/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v251.segment.EVN;
import ca.uhn.hl7v2.model.v251.segment.MSH;
import ca.uhn.hl7v2.model.v251.segment.ORG;
import ca.uhn.hl7v2.model.v251.segment.PRA;
import ca.uhn.hl7v2.model.v251.segment.SFT;
import ca.uhn.hl7v2.model.v251.segment.STF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMU_B04
extends AbstractMessage {
    public PMU_B04() {
        this(new DefaultModelClassFactory());
    }

    public PMU_B04(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EVN.class, true, false);
            this.add(STF.class, true, false);
            this.add(PRA.class, false, true);
            this.add(ORG.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PMU_B04 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public STF getSTF() {
        return this.getTyped("STF", STF.class);
    }

    public PRA getPRA() {
        return this.getTyped("PRA", PRA.class);
    }

    public PRA getPRA(int rep) {
        return this.getTyped("PRA", rep, PRA.class);
    }

    public int getPRAReps() {
        return this.getReps("PRA");
    }

    public List<PRA> getPRAAll() throws HL7Exception {
        return this.getAllAsList("PRA", PRA.class);
    }

    public void insertPRA(PRA structure, int rep) throws HL7Exception {
        super.insertRepetition("PRA", structure, rep);
    }

    public PRA insertPRA(int rep) throws HL7Exception {
        return (PRA)super.insertRepetition("PRA", rep);
    }

    public PRA removePRA(int rep) throws HL7Exception {
        return (PRA)super.removeRepetition("PRA", rep);
    }

    public ORG getORG() {
        return this.getTyped("ORG", ORG.class);
    }

    public ORG getORG(int rep) {
        return this.getTyped("ORG", rep, ORG.class);
    }

    public int getORGReps() {
        return this.getReps("ORG");
    }

    public List<ORG> getORGAll() throws HL7Exception {
        return this.getAllAsList("ORG", ORG.class);
    }

    public void insertORG(ORG structure, int rep) throws HL7Exception {
        super.insertRepetition("ORG", structure, rep);
    }

    public ORG insertORG(int rep) throws HL7Exception {
        return (ORG)super.insertRepetition("ORG", rep);
    }

    public ORG removeORG(int rep) throws HL7Exception {
        return (ORG)super.removeRepetition("ORG", rep);
    }
}

