/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ODT
extends AbstractSegment {
    public ODT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Tray Type");
            this.add(CE.class, false, 10, 250, new Object[]{this.getMessage()}, "Service Period");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Text Instruction");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ODT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getTrayType() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getOdt1_TrayType() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE[] getServicePeriod() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public CE[] getOdt2_ServicePeriod() {
        CE[] retVal = (CE[])this.getTypedField(2, new CE[0]);
        return retVal;
    }

    public int getServicePeriodReps() {
        return this.getReps(2);
    }

    public CE getServicePeriod(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public CE getOdt2_ServicePeriod(int rep) {
        CE retVal = (CE)this.getTypedField(2, rep);
        return retVal;
    }

    public int getOdt2_ServicePeriodReps() {
        return this.getReps(2);
    }

    public CE insertServicePeriod(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE insertOdt2_ServicePeriod(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(2, rep);
    }

    public CE removeServicePeriod(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public CE removeOdt2_ServicePeriod(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(2, rep);
    }

    public ST getTextInstruction() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getOdt3_TextInstruction() {
        ST retVal = (ST)this.getTypedField(3, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

