/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v26.group.OPU_R25_ACCESSION_DETAIL;
import ca.uhn.hl7v2.model.v26.segment.MSH;
import ca.uhn.hl7v2.model.v26.segment.NTE;
import ca.uhn.hl7v2.model.v26.segment.OBX;
import ca.uhn.hl7v2.model.v26.segment.PV1;
import ca.uhn.hl7v2.model.v26.segment.PV2;
import ca.uhn.hl7v2.model.v26.segment.ROL;
import ca.uhn.hl7v2.model.v26.segment.SFT;
import ca.uhn.hl7v2.model.v26.segment.UAC;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPU_R25
extends AbstractMessage {
    public OPU_R25() {
        this(new DefaultModelClassFactory());
    }

    public OPU_R25(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(UAC.class, false, false);
            this.add(NTE.class, false, false);
            this.add(PV1.class, true, false);
            this.add(PV2.class, false, false);
            this.add(OBX.class, false, true);
            this.add(NTE.class, false, true);
            this.add(ROL.class, true, true);
            this.add(OPU_R25_ACCESSION_DETAIL.class, true, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPU_R25 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.6";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public UAC getUAC() {
        return this.getTyped("UAC", UAC.class);
    }

    public NTE getNTE() {
        return this.getTyped("NTE", NTE.class);
    }

    public PV1 getPV1() {
        return this.getTyped("PV1", PV1.class);
    }

    public PV2 getPV2() {
        return this.getTyped("PV2", PV2.class);
    }

    public OBX getOBX() {
        return this.getTyped("OBX", OBX.class);
    }

    public OBX getOBX(int rep) {
        return this.getTyped("OBX", rep, OBX.class);
    }

    public int getOBXReps() {
        return this.getReps("OBX");
    }

    public List<OBX> getOBXAll() throws HL7Exception {
        return this.getAllAsList("OBX", OBX.class);
    }

    public void insertOBX(OBX structure, int rep) throws HL7Exception {
        super.insertRepetition("OBX", structure, rep);
    }

    public OBX insertOBX(int rep) throws HL7Exception {
        return (OBX)super.insertRepetition("OBX", rep);
    }

    public OBX removeOBX(int rep) throws HL7Exception {
        return (OBX)super.removeRepetition("OBX", rep);
    }

    public NTE getNTE2() {
        return this.getTyped("NTE2", NTE.class);
    }

    public NTE getNTE2(int rep) {
        return this.getTyped("NTE2", rep, NTE.class);
    }

    public int getNTE2Reps() {
        return this.getReps("NTE2");
    }

    public List<NTE> getNTE2All() throws HL7Exception {
        return this.getAllAsList("NTE2", NTE.class);
    }

    public void insertNTE2(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE2", structure, rep);
    }

    public NTE insertNTE2(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE2", rep);
    }

    public NTE removeNTE2(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE2", rep);
    }

    public ROL getROL() {
        return this.getTyped("ROL", ROL.class);
    }

    public ROL getROL(int rep) {
        return this.getTyped("ROL", rep, ROL.class);
    }

    public int getROLReps() {
        return this.getReps("ROL");
    }

    public List<ROL> getROLAll() throws HL7Exception {
        return this.getAllAsList("ROL", ROL.class);
    }

    public void insertROL(ROL structure, int rep) throws HL7Exception {
        super.insertRepetition("ROL", structure, rep);
    }

    public ROL insertROL(int rep) throws HL7Exception {
        return (ROL)super.insertRepetition("ROL", rep);
    }

    public ROL removeROL(int rep) throws HL7Exception {
        return (ROL)super.removeRepetition("ROL", rep);
    }

    public OPU_R25_ACCESSION_DETAIL getACCESSION_DETAIL() {
        return this.getTyped("ACCESSION_DETAIL", OPU_R25_ACCESSION_DETAIL.class);
    }

    public OPU_R25_ACCESSION_DETAIL getACCESSION_DETAIL(int rep) {
        return this.getTyped("ACCESSION_DETAIL", rep, OPU_R25_ACCESSION_DETAIL.class);
    }

    public int getACCESSION_DETAILReps() {
        return this.getReps("ACCESSION_DETAIL");
    }

    public List<OPU_R25_ACCESSION_DETAIL> getACCESSION_DETAILAll() throws HL7Exception {
        return this.getAllAsList("ACCESSION_DETAIL", OPU_R25_ACCESSION_DETAIL.class);
    }

    public void insertACCESSION_DETAIL(OPU_R25_ACCESSION_DETAIL structure, int rep) throws HL7Exception {
        super.insertRepetition("ACCESSION_DETAIL", structure, rep);
    }

    public OPU_R25_ACCESSION_DETAIL insertACCESSION_DETAIL(int rep) throws HL7Exception {
        return (OPU_R25_ACCESSION_DETAIL)super.insertRepetition("ACCESSION_DETAIL", rep);
    }

    public OPU_R25_ACCESSION_DETAIL removeACCESSION_DETAIL(int rep) throws HL7Exception {
        return (OPU_R25_ACCESSION_DETAIL)super.removeRepetition("ACCESSION_DETAIL", rep);
    }
}

