/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.XCN;
import ca.uhn.hl7v2.model.v26.datatype.XON;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class BTX
extends AbstractSegment {
    public BTX(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - BTX");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "BC Donation ID");
            this.add(CNE.class, false, 1, 250, new Object[]{this.getMessage()}, "BC Component");
            this.add(CNE.class, false, 1, 250, new Object[]{this.getMessage()}, "BC Blood Group");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "CP Commercial Product");
            this.add(XON.class, false, 1, 250, new Object[]{this.getMessage()}, "CP Manufacturer");
            this.add(EI.class, false, 1, 22, new Object[]{this.getMessage()}, "CP Lot Number");
            this.add(NM.class, true, 1, 5, new Object[]{this.getMessage()}, "BP Quantity");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "BP Amount");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "BP Units");
            this.add(CWE.class, true, 1, 250, new Object[]{this.getMessage()}, "BP Transfusion/Disposition Status");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(511)}, "BP Message Status");
            this.add(DTM.class, true, 1, 24, new Object[]{this.getMessage()}, "BP Date/Time of Status");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "BP Transfusion Administrator");
            this.add(XCN.class, false, 1, 250, new Object[]{this.getMessage()}, "BP Transfusion Verifier");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "BP Transfusion Start Date/Time of Status");
            this.add(DTM.class, false, 1, 24, new Object[]{this.getMessage()}, "BP Transfusion End Date/Time of Status");
            this.add(CWE.class, false, 0, 250, new Object[]{this.getMessage()}, "BP Adverse Reaction Type");
            this.add(CWE.class, false, 1, 250, new Object[]{this.getMessage()}, "BP Transfusion Interrupted Reason");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating BTX - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDBTX() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getBtx1_SetIDBTX() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public EI getBCDonationID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public EI getBtx2_BCDonationID() {
        EI retVal = (EI)this.getTypedField(2, 0);
        return retVal;
    }

    public CNE getBCComponent() {
        CNE retVal = (CNE)this.getTypedField(3, 0);
        return retVal;
    }

    public CNE getBtx3_BCComponent() {
        CNE retVal = (CNE)this.getTypedField(3, 0);
        return retVal;
    }

    public CNE getBCBloodGroup() {
        CNE retVal = (CNE)this.getTypedField(4, 0);
        return retVal;
    }

    public CNE getBtx4_BCBloodGroup() {
        CNE retVal = (CNE)this.getTypedField(4, 0);
        return retVal;
    }

    public CWE getCPCommercialProduct() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public CWE getBtx5_CPCommercialProduct() {
        CWE retVal = (CWE)this.getTypedField(5, 0);
        return retVal;
    }

    public XON getCPManufacturer() {
        XON retVal = (XON)this.getTypedField(6, 0);
        return retVal;
    }

    public XON getBtx6_CPManufacturer() {
        XON retVal = (XON)this.getTypedField(6, 0);
        return retVal;
    }

    public EI getCPLotNumber() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public EI getBtx7_CPLotNumber() {
        EI retVal = (EI)this.getTypedField(7, 0);
        return retVal;
    }

    public NM getBPQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getBtx8_BPQuantity() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getBPAmount() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getBtx9_BPAmount() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public CWE getBPUnits() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getBtx10_BPUnits() {
        CWE retVal = (CWE)this.getTypedField(10, 0);
        return retVal;
    }

    public CWE getBPTransfusionDispositionStatus() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public CWE getBtx11_BPTransfusionDispositionStatus() {
        CWE retVal = (CWE)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getBPMessageStatus() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getBtx12_BPMessageStatus() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public DTM getBPDateTimeOfStatus() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public DTM getBtx13_BPDateTimeOfStatus() {
        DTM retVal = (DTM)this.getTypedField(13, 0);
        return retVal;
    }

    public XCN getBPTransfusionAdministrator() {
        XCN retVal = (XCN)this.getTypedField(14, 0);
        return retVal;
    }

    public XCN getBtx14_BPTransfusionAdministrator() {
        XCN retVal = (XCN)this.getTypedField(14, 0);
        return retVal;
    }

    public XCN getBPTransfusionVerifier() {
        XCN retVal = (XCN)this.getTypedField(15, 0);
        return retVal;
    }

    public XCN getBtx15_BPTransfusionVerifier() {
        XCN retVal = (XCN)this.getTypedField(15, 0);
        return retVal;
    }

    public DTM getBPTransfusionStartDateTimeOfStatus() {
        DTM retVal = (DTM)this.getTypedField(16, 0);
        return retVal;
    }

    public DTM getBtx16_BPTransfusionStartDateTimeOfStatus() {
        DTM retVal = (DTM)this.getTypedField(16, 0);
        return retVal;
    }

    public DTM getBPTransfusionEndDateTimeOfStatus() {
        DTM retVal = (DTM)this.getTypedField(17, 0);
        return retVal;
    }

    public DTM getBtx17_BPTransfusionEndDateTimeOfStatus() {
        DTM retVal = (DTM)this.getTypedField(17, 0);
        return retVal;
    }

    public CWE[] getBPAdverseReactionType() {
        CWE[] retVal = (CWE[])this.getTypedField(18, new CWE[0]);
        return retVal;
    }

    public CWE[] getBtx18_BPAdverseReactionType() {
        CWE[] retVal = (CWE[])this.getTypedField(18, new CWE[0]);
        return retVal;
    }

    public int getBPAdverseReactionTypeReps() {
        return this.getReps(18);
    }

    public CWE getBPAdverseReactionType(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public CWE getBtx18_BPAdverseReactionType(int rep) {
        CWE retVal = (CWE)this.getTypedField(18, rep);
        return retVal;
    }

    public int getBtx18_BPAdverseReactionTypeReps() {
        return this.getReps(18);
    }

    public CWE insertBPAdverseReactionType(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE insertBtx18_BPAdverseReactionType(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(18, rep);
    }

    public CWE removeBPAdverseReactionType(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public CWE removeBtx18_BPAdverseReactionType(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(18, rep);
    }

    public CWE getBPTransfusionInterruptedReason() {
        CWE retVal = (CWE)this.getTypedField(19, 0);
        return retVal;
    }

    public CWE getBtx19_BPTransfusionInterruptedReason() {
        CWE retVal = (CWE)this.getTypedField(19, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new EI(this.getMessage());
            }
            case 2: {
                return new CNE(this.getMessage());
            }
            case 3: {
                return new CNE(this.getMessage());
            }
            case 4: {
                return new CWE(this.getMessage());
            }
            case 5: {
                return new XON(this.getMessage());
            }
            case 6: {
                return new EI(this.getMessage());
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new CWE(this.getMessage());
            }
            case 10: {
                return new CWE(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(511));
            }
            case 12: {
                return new DTM(this.getMessage());
            }
            case 13: {
                return new XCN(this.getMessage());
            }
            case 14: {
                return new XCN(this.getMessage());
            }
            case 15: {
                return new DTM(this.getMessage());
            }
            case 16: {
                return new DTM(this.getMessage());
            }
            case 17: {
                return new CWE(this.getMessage());
            }
            case 18: {
                return new CWE(this.getMessage());
            }
        }
        return null;
    }
}

