/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Proxy;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyPair;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadException;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExist;
import org.apache.camel.component.file.GenericFileOperationFailedException;
import org.apache.camel.component.file.remote.DSAKeyPairIdentity;
import org.apache.camel.component.file.remote.RSAKeyPairIdentity;
import org.apache.camel.component.file.remote.RemoteFileConfiguration;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.component.file.remote.SftpConfiguration;
import org.apache.camel.component.file.remote.SftpEndpoint;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.FileUtil;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ResourceHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.TimeUtils;
import org.slf4j.LoggerFactory;

public class SftpOperations
implements RemoteFileOperations<ChannelSftp.LsEntry> {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(SftpOperations.class);
    private static final Pattern UP_DIR_PATTERN = Pattern.compile("/[^/]+");
    private Proxy proxy;
    private SftpEndpoint endpoint;
    private ChannelSftp channel;
    private Session session;

    public SftpOperations() {
    }

    public SftpOperations(Proxy proxy) {
        this.proxy = proxy;
    }

    public void setEndpoint(GenericFileEndpoint<ChannelSftp.LsEntry> endpoint) {
        this.endpoint = (SftpEndpoint)endpoint;
    }

    @Override
    public boolean connect(RemoteFileConfiguration configuration) throws GenericFileOperationFailedException {
        if (this.isConnected()) {
            return true;
        }
        boolean connected = false;
        int attempt = 0;
        while (!connected) {
            try {
                if (LOG.isTraceEnabled() && attempt > 0) {
                    LOG.trace("Reconnect attempt #{} connecting to + {}", (Object)attempt, (Object)configuration.remoteServerInformation());
                }
                if (this.channel == null || !this.channel.isConnected()) {
                    if (this.session == null || !this.session.isConnected()) {
                        LOG.trace("Session isn't connected, trying to recreate and connect.");
                        this.session = this.createSession(configuration);
                        if (this.endpoint.getConfiguration().getConnectTimeout() > 0) {
                            LOG.trace("Connecting use connectTimeout: " + this.endpoint.getConfiguration().getConnectTimeout() + " ...");
                            this.session.connect(this.endpoint.getConfiguration().getConnectTimeout());
                        } else {
                            LOG.trace("Connecting ...");
                            this.session.connect();
                        }
                    }
                    LOG.trace("Channel isn't connected, trying to recreate and connect.");
                    this.channel = (ChannelSftp)this.session.openChannel("sftp");
                    if (this.endpoint.getConfiguration().getConnectTimeout() > 0) {
                        LOG.trace("Connecting use connectTimeout: " + this.endpoint.getConfiguration().getConnectTimeout() + " ...");
                        this.channel.connect(this.endpoint.getConfiguration().getConnectTimeout());
                    } else {
                        LOG.trace("Connecting ...");
                        this.channel.connect();
                    }
                    LOG.info("Connected to " + configuration.remoteServerInformation());
                }
                connected = true;
            }
            catch (Exception e) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new GenericFileOperationFailedException("Interrupted during connecting", (Throwable)new InterruptedException("Interrupted during connecting"));
                }
                GenericFileOperationFailedException failed = new GenericFileOperationFailedException("Cannot connect to " + configuration.remoteServerInformation(), (Throwable)e);
                LOG.trace("Cannot connect due: {}", (Object)failed.getMessage());
                if (++attempt > this.endpoint.getMaximumReconnectAttempts()) {
                    throw failed;
                }
                if (this.endpoint.getReconnectDelay() <= 0L) continue;
                try {
                    Thread.sleep(this.endpoint.getReconnectDelay());
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new GenericFileOperationFailedException("Interrupted during sleeping", (Throwable)ie);
                }
            }
        }
        return true;
    }

    protected Session createSession(final RemoteFileConfiguration configuration) throws JSchException {
        byte[] passphrase;
        JSch jsch = new JSch();
        JSch.setLogger((Logger)new JSchLogger());
        SftpConfiguration sftpConfig = (SftpConfiguration)configuration;
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getCiphers())) {
            LOG.debug("Using ciphers: {}", (Object)sftpConfig.getCiphers());
            Hashtable<String, String> ciphers = new Hashtable<String, String>();
            ciphers.put("cipher.s2c", sftpConfig.getCiphers());
            ciphers.put("cipher.c2s", sftpConfig.getCiphers());
            JSch.setConfig(ciphers);
        }
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getPrivateKeyFile())) {
            LOG.debug("Using private keyfile: {}", (Object)sftpConfig.getPrivateKeyFile());
            if (ObjectHelper.isNotEmpty((Object)sftpConfig.getPrivateKeyPassphrase())) {
                jsch.addIdentity(sftpConfig.getPrivateKeyFile(), sftpConfig.getPrivateKeyPassphrase());
            } else {
                jsch.addIdentity(sftpConfig.getPrivateKeyFile());
            }
        }
        if (sftpConfig.getPrivateKey() != null) {
            LOG.debug("Using private key information from byte array");
            passphrase = null;
            if (ObjectHelper.isNotEmpty((Object)sftpConfig.getPrivateKeyPassphrase())) {
                try {
                    passphrase = sftpConfig.getPrivateKeyPassphrase().getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new JSchException("Cannot transform passphrase to byte[]", (Throwable)e);
                }
            }
            jsch.addIdentity("ID", sftpConfig.getPrivateKey(), null, passphrase);
        }
        if (sftpConfig.getPrivateKeyUri() != null) {
            LOG.debug("Using private key uri : {}", (Object)sftpConfig.getPrivateKeyUri());
            passphrase = null;
            if (ObjectHelper.isNotEmpty((Object)sftpConfig.getPrivateKeyPassphrase())) {
                try {
                    passphrase = sftpConfig.getPrivateKeyPassphrase().getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new JSchException("Cannot transform passphrase to byte[]", (Throwable)e);
                }
            }
            try {
                InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.endpoint.getCamelContext().getClassResolver(), (String)sftpConfig.getPrivateKeyUri());
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)bos);
                jsch.addIdentity("ID", bos.toByteArray(), null, passphrase);
            }
            catch (IOException e) {
                throw new JSchException("Cannot read resource: " + sftpConfig.getPrivateKeyUri(), (Throwable)e);
            }
        }
        if (sftpConfig.getKeyPair() != null) {
            LOG.debug("Using private key information from key pair");
            KeyPair keyPair = sftpConfig.getKeyPair();
            if (keyPair.getPrivate() != null && keyPair.getPublic() != null) {
                if (keyPair.getPrivate() instanceof RSAPrivateKey && keyPair.getPublic() instanceof RSAPublicKey) {
                    jsch.addIdentity((Identity)new RSAKeyPairIdentity("ID", keyPair), null);
                } else if (keyPair.getPrivate() instanceof DSAPrivateKey && keyPair.getPublic() instanceof DSAPublicKey) {
                    jsch.addIdentity((Identity)new DSAKeyPairIdentity("ID", keyPair), null);
                } else {
                    LOG.warn("Only RSA and DSA key pairs are supported");
                }
            } else {
                LOG.warn("PrivateKey and PublicKey in the KeyPair must be filled");
            }
        }
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getKnownHostsFile())) {
            LOG.debug("Using knownhosts file: {}", (Object)sftpConfig.getKnownHostsFile());
            jsch.setKnownHosts(sftpConfig.getKnownHostsFile());
        }
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getKnownHostsUri())) {
            LOG.debug("Using knownhosts uri: {}", (Object)sftpConfig.getKnownHostsUri());
            try {
                InputStream is = ResourceHelper.resolveMandatoryResourceAsInputStream((ClassResolver)this.endpoint.getCamelContext().getClassResolver(), (String)sftpConfig.getKnownHostsUri());
                jsch.setKnownHosts(is);
            }
            catch (IOException e) {
                throw new JSchException("Cannot read resource: " + sftpConfig.getKnownHostsUri(), (Throwable)e);
            }
        }
        if (sftpConfig.getKnownHosts() != null) {
            LOG.debug("Using knownhosts information from byte array");
            jsch.setKnownHosts((InputStream)new ByteArrayInputStream(sftpConfig.getKnownHosts()));
        }
        Session session = jsch.getSession(configuration.getUsername(), configuration.getHost(), configuration.getPort());
        if (ObjectHelper.isNotEmpty((Object)sftpConfig.getStrictHostKeyChecking())) {
            LOG.debug("Using StrickHostKeyChecking: {}", (Object)sftpConfig.getStrictHostKeyChecking());
            session.setConfig("StrictHostKeyChecking", sftpConfig.getStrictHostKeyChecking());
        }
        session.setServerAliveInterval(sftpConfig.getServerAliveInterval());
        session.setServerAliveCountMax(sftpConfig.getServerAliveCountMax());
        if (sftpConfig.getCompression() > 0) {
            LOG.debug("Using compression: {}", (Object)sftpConfig.getCompression());
            session.setConfig("compression.s2c", "zlib@openssh.com,zlib,none");
            session.setConfig("compression.c2s", "zlib@openssh.com,zlib,none");
            session.setConfig("compression_level", Integer.toString(sftpConfig.getCompression()));
        }
        if (sftpConfig.getPreferredAuthentications() != null) {
            LOG.debug("Using PreferredAuthentications: {}", (Object)sftpConfig.getPreferredAuthentications());
            session.setConfig("PreferredAuthentications", sftpConfig.getPreferredAuthentications());
        }
        session.setUserInfo((UserInfo)new ExtendedUserInfo(){

            public String getPassphrase() {
                return null;
            }

            public String getPassword() {
                return configuration.getPassword();
            }

            public boolean promptPassword(String s) {
                return true;
            }

            public boolean promptPassphrase(String s) {
                return true;
            }

            public boolean promptYesNo(String s) {
                LOG.warn("Server asks for confirmation (yes|no): " + s + ". Camel will answer no.");
                return false;
            }

            public void showMessage(String s) {
                LOG.trace("Message received from Server: " + s);
            }

            public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
                if (configuration.getPassword() == null) {
                    return new String[0];
                }
                return new String[]{configuration.getPassword()};
            }
        });
        if (this.proxy != null) {
            session.setProxy(this.proxy);
        }
        return session;
    }

    @Override
    public boolean isConnected() throws GenericFileOperationFailedException {
        return this.session != null && this.session.isConnected() && this.channel != null && this.channel.isConnected();
    }

    @Override
    public void disconnect() throws GenericFileOperationFailedException {
        if (this.session != null && this.session.isConnected()) {
            this.session.disconnect();
        }
        if (this.channel != null && this.channel.isConnected()) {
            this.channel.disconnect();
        }
    }

    public boolean deleteFile(String name) throws GenericFileOperationFailedException {
        LOG.debug("Deleting file: {}", (Object)name);
        try {
            this.channel.rm(name);
            return true;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot delete file: " + name, (Throwable)e);
        }
    }

    public boolean renameFile(String from, String to) throws GenericFileOperationFailedException {
        LOG.debug("Renaming file: {} to: {}", (Object)from, (Object)to);
        try {
            this.channel.rename(from, to);
            return true;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot rename file from: " + from + " to: " + to, (Throwable)e);
        }
    }

    public boolean buildDirectory(String directory, boolean absolute) throws GenericFileOperationFailedException {
        directory = this.endpoint.getConfiguration().normalizePath(directory);
        LOG.trace("buildDirectory({},{})", (Object)directory, (Object)absolute);
        boolean success = false;
        String originalDirectory = this.getCurrentDirectory();
        try {
            try {
                this.channel.cd(directory);
                success = true;
            }
            catch (SftpException sftpException) {
                // empty catch block
            }
            if (!success) {
                LOG.debug("Trying to build remote directory: {}", (Object)directory);
                try {
                    this.channel.mkdir(directory);
                    success = true;
                }
                catch (SftpException e) {
                    success = this.buildDirectoryChunks(directory);
                }
            }
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot build directory: " + directory, (Throwable)e);
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot build directory: " + directory, (Throwable)e);
        }
        finally {
            if (originalDirectory != null) {
                this.changeCurrentDirectory(originalDirectory);
            }
        }
        return success;
    }

    private boolean buildDirectoryChunks(String dirName) throws IOException, SftpException {
        StringBuilder sb = new StringBuilder(dirName.length());
        String[] dirs = dirName.split("/|\\\\");
        boolean success = false;
        for (String dir : dirs) {
            sb.append(dir).append('/');
            String directory = this.endpoint.getConfiguration().normalizePath(sb.toString());
            if (directory.equals("/") || directory.equals("\\")) continue;
            try {
                LOG.trace("Trying to build remote directory by chunk: {}", (Object)directory);
                this.channel.mkdir(directory);
                success = true;
            }
            catch (SftpException sftpException) {
                // empty catch block
            }
        }
        return success;
    }

    public String getCurrentDirectory() throws GenericFileOperationFailedException {
        LOG.trace("getCurrentDirectory()");
        try {
            String answer = this.channel.pwd();
            LOG.trace("Current dir: {}", (Object)answer);
            return answer;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot get current directory", (Throwable)e);
        }
    }

    public void changeCurrentDirectory(String path) throws GenericFileOperationFailedException {
        String[] dirs;
        LOG.trace("changeCurrentDirectory({})", (Object)path);
        if (ObjectHelper.isEmpty((Object)path)) {
            return;
        }
        String before = path;
        char separatorChar = '/';
        path = FileUtil.compactPath((String)path, (char)separatorChar);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Compacted path: {} -> {} using separator: {}", new Object[]{before, path, Character.valueOf(separatorChar)});
        }
        if (!this.endpoint.getConfiguration().isStepwise()) {
            this.doChangeDirectory(path);
            return;
        }
        if (this.getCurrentDirectory().startsWith(path)) {
            String p = this.getCurrentDirectory().substring(path.length() - (path.endsWith("/") ? 1 : 0));
            if (p.length() == 0) {
                return;
            }
            path = UP_DIR_PATTERN.matcher(p).replaceAll("/..").substring(1);
        }
        if (FileUtil.hasLeadingSeparator((String)path)) {
            this.doChangeDirectory(path.substring(0, 1));
            path = path.substring(1);
        }
        if ((dirs = path.split("/|\\\\")) == null || dirs.length == 0) {
            this.doChangeDirectory(path);
            return;
        }
        for (String dir : dirs) {
            this.doChangeDirectory(dir);
        }
    }

    private void doChangeDirectory(String path) {
        if (path == null || ".".equals(path) || ObjectHelper.isEmpty((Object)path)) {
            return;
        }
        LOG.trace("Changing directory: {}", (Object)path);
        try {
            this.channel.cd(path);
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot change directory to: " + path, (Throwable)e);
        }
    }

    public void changeToParentDirectory() throws GenericFileOperationFailedException {
        LOG.trace("changeToParentDirectory()");
        String current = this.getCurrentDirectory();
        String parent = FileUtil.compactPath((String)(current + "/.."));
        if (!parent.startsWith("/")) {
            parent = "/" + parent;
        }
        this.changeCurrentDirectory(parent);
    }

    public List<ChannelSftp.LsEntry> listFiles() throws GenericFileOperationFailedException {
        return this.listFiles(".");
    }

    public List<ChannelSftp.LsEntry> listFiles(String path) throws GenericFileOperationFailedException {
        LOG.trace("listFiles({})", (Object)path);
        if (ObjectHelper.isEmpty((Object)path)) {
            path = ".";
        }
        try {
            ArrayList<ChannelSftp.LsEntry> list = new ArrayList<ChannelSftp.LsEntry>();
            Vector files = this.channel.ls(path);
            if (files != null) {
                for (Object file : files) {
                    list.add((ChannelSftp.LsEntry)file);
                }
            }
            return list;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot list directory: " + path, (Throwable)e);
        }
    }

    public boolean retrieveFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
        LOG.trace("retrieveFile({})", (Object)name);
        if (ObjectHelper.isNotEmpty((Object)this.endpoint.getLocalWorkDirectory())) {
            return this.retrieveFileToFileInLocalWorkDirectory(name, exchange);
        }
        return this.retrieveFileToStreamInBody(name, exchange);
    }

    public void releaseRetreivedFileResources(Exchange exchange) throws GenericFileOperationFailedException {
        InputStream is = (InputStream)exchange.getIn().getHeader("CamelRemoteFileInputStream", InputStream.class);
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean retrieveFileToStreamInBody(String name, Exchange exchange) throws GenericFileOperationFailedException {
        boolean bl;
        ByteArrayOutputStream os = null;
        String currentDir = null;
        try {
            GenericFile target = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
            ObjectHelper.notNull((Object)target, (String)"Exchange should have the CamelFileExchangeFile set");
            String remoteName = name;
            if (this.endpoint.getConfiguration().isStepwise()) {
                currentDir = this.getCurrentDirectory();
                String path = FileUtil.onlyPath((String)name);
                if (path != null) {
                    this.changeCurrentDirectory(path);
                }
                remoteName = FileUtil.stripPath((String)name);
            }
            InputStream is = this.channel.get(remoteName);
            if (this.endpoint.getConfiguration().isStreamDownload()) {
                target.setBody((Object)is);
                exchange.getIn().setHeader("CamelRemoteFileInputStream", (Object)is);
            } else {
                os = new ByteArrayOutputStream();
                target.setBody((Object)os);
                IOHelper.copyAndCloseInput((InputStream)is, (OutputStream)os);
            }
            bl = true;
        }
        catch (IOException e) {
            try {
                throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
                catch (SftpException e2) {
                    throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(os, (String)("retrieve: " + name), (org.slf4j.Logger)LOG);
                if (currentDir != null) {
                    this.changeCurrentDirectory(currentDir);
                }
                throw throwable;
            }
        }
        IOHelper.close((Closeable)os, (String)("retrieve: " + name), (org.slf4j.Logger)LOG);
        if (currentDir != null) {
            this.changeCurrentDirectory(currentDir);
        }
        return bl;
    }

    private boolean retrieveFileToFileInLocalWorkDirectory(String name, Exchange exchange) throws GenericFileOperationFailedException {
        FileOutputStream os;
        File temp;
        File local = new File(this.endpoint.getLocalWorkDirectory());
        GenericFile file = (GenericFile)exchange.getProperty("CamelFileExchangeFile");
        ObjectHelper.notNull((Object)file, (String)"Exchange should have the CamelFileExchangeFile set");
        try {
            String relativeName = file.getRelativeFilePath();
            temp = new File(local, relativeName + ".inprogress");
            local = new File(local, relativeName);
            local.mkdirs();
            if (temp.exists() && !FileUtil.deleteFile((File)temp)) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + temp);
            }
            if (local.exists() && !FileUtil.deleteFile((File)local)) {
                throw new GenericFileOperationFailedException("Cannot delete existing local work file: " + local);
            }
            if (!temp.createNewFile()) {
                throw new GenericFileOperationFailedException("Cannot create new local work file: " + temp);
            }
            os = new FileOutputStream(temp);
            exchange.getIn().setHeader("CamelFileLocalWorkPath", (Object)local.getPath());
        }
        catch (Exception e) {
            throw new GenericFileOperationFailedException("Cannot create new local work file: " + local);
        }
        String currentDir = null;
        try {
            file.setBody((Object)local);
            String remoteName = name;
            if (this.endpoint.getConfiguration().isStepwise()) {
                currentDir = this.getCurrentDirectory();
                String path = FileUtil.onlyPath((String)name);
                if (path != null) {
                    this.changeCurrentDirectory(path);
                }
                remoteName = FileUtil.stripPath((String)name);
            }
            this.channel.get(remoteName, (OutputStream)os);
        }
        catch (SftpException e) {
            LOG.trace("Error occurred during retrieving file: {} to local directory. Deleting local work file: {}", (Object)name, (Object)temp);
            IOHelper.close((Closeable)os, (String)("retrieve: " + name), (org.slf4j.Logger)LOG);
            boolean deleted = FileUtil.deleteFile((File)temp);
            if (!deleted) {
                LOG.warn("Error occurred during retrieving file: " + name + " to local directory. Cannot delete local work file: " + temp);
            }
            throw new GenericFileOperationFailedException("Cannot retrieve file: " + name, (Throwable)e);
        }
        finally {
            IOHelper.close((Closeable)os, (String)("retrieve: " + name), (org.slf4j.Logger)LOG);
            if (currentDir != null) {
                this.changeCurrentDirectory(currentDir);
            }
        }
        LOG.debug("Retrieve file to local work file result: true");
        LOG.trace("Renaming local in progress file from: {} to: {}", (Object)temp, (Object)local);
        try {
            if (!FileUtil.renameFile((File)temp, (File)local, (boolean)false)) {
                throw new GenericFileOperationFailedException("Cannot rename local work file from: " + temp + " to: " + local);
            }
        }
        catch (IOException e) {
            throw new GenericFileOperationFailedException("Cannot rename local work file from: " + temp + " to: " + local, (Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean storeFile(String name, Exchange exchange) throws GenericFileOperationFailedException {
        name = this.endpoint.getConfiguration().normalizePath(name);
        LOG.trace("storeFile({})", (Object)name);
        boolean answer = false;
        String currentDir = null;
        String path = FileUtil.onlyPath((String)name);
        String targetName = name;
        try {
            if (path != null && this.endpoint.getConfiguration().isStepwise()) {
                currentDir = this.getCurrentDirectory();
                this.changeCurrentDirectory(path);
                targetName = FileUtil.stripPath((String)name);
            }
            answer = this.doStoreFile(name, targetName, exchange);
            if (currentDir == null) return answer;
        }
        catch (Throwable throwable) {
            if (currentDir == null) throw throwable;
            this.changeCurrentDirectory(currentDir);
            throw throwable;
        }
        this.changeCurrentDirectory(currentDir);
        return answer;
    }

    private boolean doStoreFile(String name, String targetName, Exchange exchange) throws GenericFileOperationFailedException {
        LOG.trace("doStoreFile({})", (Object)targetName);
        if (this.endpoint.getFileExist() == GenericFileExist.Ignore || this.endpoint.getFileExist() == GenericFileExist.Fail || this.endpoint.getFileExist() == GenericFileExist.Move) {
            boolean existFile = this.existsFile(targetName);
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Ignore) {
                LOG.trace("An existing file already exists: {}. Ignore and do not override it.", (Object)name);
                return true;
            }
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Fail) {
                throw new GenericFileOperationFailedException("File already exist: " + name + ". Cannot write new file.");
            }
            if (existFile && this.endpoint.getFileExist() == GenericFileExist.Move) {
                this.doMoveExistingFile(name, targetName);
            }
        }
        InputStream is = null;
        if (exchange.getIn().getBody() == null) {
            if (this.endpoint.isAllowNullBody()) {
                LOG.trace("Writing empty file.");
                is = new ByteArrayInputStream(new byte[0]);
            } else {
                throw new GenericFileOperationFailedException("Cannot write null body to file: " + name);
            }
        }
        try {
            String mode;
            if (is == null) {
                String charset = this.endpoint.getCharset();
                if (charset != null) {
                    is = new ByteArrayInputStream(((String)exchange.getIn().getMandatoryBody(String.class)).getBytes(charset));
                    LOG.trace("Using InputStream {} with charset {}.", (Object)is, (Object)charset);
                } else {
                    is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
                }
            }
            StopWatch watch = new StopWatch();
            LOG.debug("About to store file: {} using stream: {}", (Object)targetName, is);
            if (this.endpoint.getFileExist() == GenericFileExist.Append) {
                LOG.trace("Client appendFile: {}", (Object)targetName);
                this.channel.put(is, targetName, 2);
            } else {
                LOG.trace("Client storeFile: {}", (Object)targetName);
                this.channel.put(is, targetName);
            }
            watch.stop();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Took {} ({} millis) to store file: {} and FTP client returned: true", new Object[]{TimeUtils.printDuration((double)watch.taken()), watch.taken(), targetName});
            }
            if (ObjectHelper.isNotEmpty((Object)(mode = this.endpoint.getConfiguration().getChmod()))) {
                int permissions = Integer.parseInt(mode, 8);
                LOG.trace("Setting chmod: {} on file: {}", (Object)mode, (Object)targetName);
                this.channel.chmod(permissions, targetName);
            }
            boolean bl = true;
            return bl;
        }
        catch (SftpException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e);
        }
        catch (InvalidPayloadException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new GenericFileOperationFailedException("Cannot store file: " + name, (Throwable)e);
        }
        finally {
            IOHelper.close((Closeable)is, (String)("store: " + name), (org.slf4j.Logger)LOG);
        }
    }

    private void doMoveExistingFile(String name, String targetName) throws GenericFileOperationFailedException {
        Exchange dummy = this.endpoint.createExchange();
        Object parent = null;
        String onlyName = FileUtil.stripPath((String)targetName);
        dummy.getIn().setHeader("CamelFileName", (Object)targetName);
        dummy.getIn().setHeader("CamelFileNameOnly", (Object)onlyName);
        dummy.getIn().setHeader("CamelFileParent", parent);
        String to = (String)this.endpoint.getMoveExisting().evaluate(dummy, String.class);
        to = FileUtil.stripLeadingSeparator((String)to);
        to = this.endpoint.getConfiguration().normalizePath(to);
        if (ObjectHelper.isEmpty((Object)to)) {
            throw new GenericFileOperationFailedException("moveExisting evaluated as empty String, cannot move existing file: " + name);
        }
        String dir = FileUtil.onlyPath((String)to);
        if (dir != null) {
            this.buildDirectory(dir, false);
        }
        if (this.existsFile(to)) {
            if (this.endpoint.isEagerDeleteTargetFile()) {
                LOG.trace("Deleting existing file: {}", (Object)to);
                this.deleteFile(to);
            } else {
                throw new GenericFileOperationFailedException("Cannot moved existing file from: " + name + " to: " + to + " as there already exists a file: " + to);
            }
        }
        LOG.trace("Moving existing file: {} to: {}", (Object)name, (Object)to);
        if (!this.renameFile(targetName, to)) {
            throw new GenericFileOperationFailedException("Cannot rename file from: " + name + " to: " + to);
        }
    }

    public boolean existsFile(String name) throws GenericFileOperationFailedException {
        LOG.trace("existsFile({})", (Object)name);
        if (this.endpoint.isFastExistsCheck()) {
            return this.fastExistsFile(name);
        }
        String directory = FileUtil.onlyPath((String)name);
        if (directory == null) {
            directory = ".";
        }
        String onlyName = FileUtil.stripPath((String)name);
        try {
            Vector files = this.channel.ls(directory);
            if (files == null) {
                return false;
            }
            for (Object file : files) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)file;
                String existing = entry.getFilename();
                LOG.trace("Existing file: {}, target file: {}", (Object)existing, (Object)name);
                if ((existing = FileUtil.stripPath((String)existing)) == null || !existing.equals(onlyName)) continue;
                return true;
            }
            return false;
        }
        catch (SftpException e) {
            if (2 == e.id) {
                return false;
            }
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    protected boolean fastExistsFile(String name) throws GenericFileOperationFailedException {
        LOG.trace("fastExistsFile({})", (Object)name);
        try {
            Vector files = this.channel.ls(name);
            if (files == null) {
                return false;
            }
            return files.size() >= 1;
        }
        catch (SftpException e) {
            if (2 == e.id) {
                return false;
            }
            throw new GenericFileOperationFailedException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean sendNoop() throws GenericFileOperationFailedException {
        if (this.isConnected()) {
            try {
                this.session.sendIgnore();
                return true;
            }
            catch (Exception e) {
                LOG.debug("SFTP session was closed. Ignoring this exception.", (Throwable)e);
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean sendSiteCommand(String command) throws GenericFileOperationFailedException {
        return true;
    }

    private static final class JSchLogger
    implements Logger {
        private JSchLogger() {
        }

        public boolean isEnabled(int level) {
            switch (level) {
                case 4: {
                    return LOG.isErrorEnabled();
                }
                case 3: {
                    return LOG.isErrorEnabled();
                }
                case 2: {
                    return LOG.isWarnEnabled();
                }
                case 1: {
                    return LOG.isInfoEnabled();
                }
            }
            return LOG.isDebugEnabled();
        }

        public void log(int level, String message) {
            switch (level) {
                case 4: {
                    LOG.error("JSCH -> " + message);
                    break;
                }
                case 3: {
                    LOG.error("JSCH -> " + message);
                    break;
                }
                case 2: {
                    LOG.warn("JSCH -> " + message);
                    break;
                }
                case 1: {
                    LOG.info("JSCH -> " + message);
                    break;
                }
                default: {
                    LOG.debug("JSCH -> " + message);
                }
            }
        }
    }

    public static interface ExtendedUserInfo
    extends UserInfo,
    UIKeyboardInteractive {
    }
}

