/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.osgi.internal;

import java.net.URL;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.switchyard.common.io.pull.PropertiesPuller;
import org.switchyard.deploy.osgi.NamespaceHandler;
import org.switchyard.deploy.osgi.base.SimpleExtension;
import org.switchyard.deploy.osgi.internal.SimpleNamespaceHandler;
import org.switchyard.deploy.osgi.internal.SwitchYardExtender;

public class ConfigurationExtension
extends SimpleExtension {
    private final Logger _logger = LoggerFactory.getLogger(SwitchYardExtender.class);
    private final SwitchYardExtender _extender;
    private SimpleNamespaceHandler _handler;
    private ServiceRegistration<NamespaceHandler> _registration;

    public ConfigurationExtension(SwitchYardExtender extender, Bundle bundle) {
        super(bundle);
        this._extender = extender;
    }

    @Override
    protected void doStart() throws Exception {
        URL configUrl = this.getBundle().getEntry("/org/switchyard/config/model/descriptor.properties");
        Properties properties = (Properties)new PropertiesPuller().pull(configUrl);
        this._handler = new SimpleNamespaceHandler(this.getBundle(), properties);
        this._logger.info("Registering namespace handler for " + this._handler.getNamespaces());
        if (this._registration == null) {
            Hashtable<String, List<String>> props = new Hashtable<String, List<String>>();
            ((Dictionary)props).put("switchyard.namespaces", this._handler.getNamespaces());
            this._registration = this.getBundleContext().registerService(NamespaceHandler.class, (Object)this._handler, props);
        }
    }

    @Override
    protected void doDestroy() throws Exception {
        if (this._handler != null) {
            this._logger.info("Unregistering namespace handler for " + this._handler.getNamespaces());
            if (this._registration != null) {
                this._registration.unregister();
                this._registration = null;
            }
        }
    }
}

