/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms;

import java.util.concurrent.ThreadFactory;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import org.apache.camel.component.jms.DefaultTaskExecutorType;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.util.concurrent.CamelThreadFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jms.JmsException;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.jms.support.JmsUtils;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

public class DefaultJmsMessageListenerContainer
extends DefaultMessageListenerContainer {
    private final JmsEndpoint endpoint;
    private final boolean allowQuickStop;

    public DefaultJmsMessageListenerContainer(JmsEndpoint endpoint) {
        this(endpoint, true);
    }

    public DefaultJmsMessageListenerContainer(JmsEndpoint endpoint, boolean allowQuickStop) {
        this.endpoint = endpoint;
        this.allowQuickStop = allowQuickStop;
    }

    protected boolean isAllowQuickStop() {
        return this.allowQuickStop;
    }

    protected boolean runningAllowed() {
        boolean quickStop = false;
        if (this.isAllowQuickStop() && !this.endpoint.isAcceptMessagesWhileStopping()) {
            quickStop = this.endpoint.getCamelContext().getStatus().isStopping();
        }
        if (quickStop) {
            this.logger.debug((Object)"runningAllowed() -> false due CamelContext is stopping and endpoint configured to not accept messages while stopping");
            return false;
        }
        boolean answer = this.endpoint.isRunning();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("runningAllowed() -> " + answer));
        }
        return answer;
    }

    protected TaskExecutor createDefaultTaskExecutor() {
        String beanName;
        String pattern = this.endpoint.getCamelContext().getExecutorServiceManager().getThreadNamePattern();
        String string = beanName = this.getBeanName() == null ? this.endpoint.getThreadName() : this.getBeanName();
        if (this.endpoint.getDefaultTaskExecutorType() == DefaultTaskExecutorType.ThreadPool) {
            ThreadPoolTaskExecutor answer = new ThreadPoolTaskExecutor();
            answer.setBeanName(beanName);
            answer.setThreadFactory((ThreadFactory)new CamelThreadFactory(pattern, beanName, true));
            answer.setCorePoolSize(this.endpoint.getConcurrentConsumers());
            answer.setQueueCapacity(0);
            answer.initialize();
            return answer;
        }
        SimpleAsyncTaskExecutor answer = new SimpleAsyncTaskExecutor(beanName);
        answer.setThreadFactory((ThreadFactory)new CamelThreadFactory(pattern, beanName, true));
        return answer;
    }

    public void stop() throws JmsException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Stopping listenerContainer: " + (Object)((Object)this) + " with cacheLevel: " + this.getCacheLevel() + " and sharedConnectionEnabled: " + this.sharedConnectionEnabled()));
        }
        super.stop();
    }

    public void destroy() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Destroying listenerContainer: " + (Object)((Object)this) + " with cacheLevel: " + this.getCacheLevel() + " and sharedConnectionEnabled: " + this.sharedConnectionEnabled()));
        }
        super.destroy();
    }

    protected void stopSharedConnection() {
        if (this.logger.isDebugEnabled() && this.sharedConnectionEnabled()) {
            this.logger.debug((Object)("Stopping shared connection on listenerContainer: " + (Object)((Object)this)));
        }
        super.stopSharedConnection();
    }

    protected void refreshConnectionUntilSuccessful() {
        while (this.isRunning()) {
            try {
                if (this.sharedConnectionEnabled()) {
                    this.refreshSharedConnection();
                } else {
                    Connection con = this.createConnection();
                    JmsUtils.closeConnection((Connection)con);
                }
                this.logger.info((Object)"Successfully refreshed JMS Connection");
                break;
            }
            catch (NullPointerException npe) {
                this.logger.debug((Object)"Could not refresh JMS Connection. Reinitializing ConnectionFactory to prevent reconnect loop.", (Throwable)npe);
                this.endpoint.getComponent().getConfiguration().setConnectionFactory(null);
                ConnectionFactory newConnectionFactory = this.endpoint.getComponent().getConfiguration().getConnectionFactory();
                if (newConnectionFactory != null) {
                    this.setConnectionFactory(newConnectionFactory);
                } else {
                    this.logger.debug((Object)"ConnectionFactory could not be recreated automatically. Please restart spring-jms.");
                }
            }
            catch (Exception ex) {
                if (ex instanceof JMSException) {
                    this.invokeExceptionListener((JMSException)ex);
                }
                StringBuilder msg = new StringBuilder();
                msg.append("Could not refresh JMS Connection for destination '");
                msg.append(this.getDestinationDescription()).append("' - retrying in ");
                msg.append(5000L).append(" ms. Cause: ");
                msg.append(ex instanceof JMSException ? JmsUtils.buildExceptionMessage((JMSException)((JMSException)ex)) : ex.getMessage());
                if (this.logger.isDebugEnabled()) {
                    this.logger.error((Object)msg, (Throwable)ex);
                }
                this.logger.error((Object)msg);
            }
            this.sleepInbetweenRecoveryAttempts();
        }
    }

    protected void sleepInbetweenRecoveryAttempts() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interEx) {
            Thread.currentThread().interrupt();
        }
    }
}

