/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v21.segment.EVN;
import ca.uhn.hl7v2.model.v21.segment.FT1;
import ca.uhn.hl7v2.model.v21.segment.MSH;
import ca.uhn.hl7v2.model.v21.segment.PID;
import ca.uhn.hl7v2.model.v21.segment.PV1;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DFT_P03
extends AbstractMessage {
    public DFT_P03() {
        this(new DefaultModelClassFactory());
    }

    public DFT_P03(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EVN.class, true, false);
            this.add(PID.class, true, false);
            this.add(PV1.class, false, false);
            this.add(FT1.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating DFT_P03 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.1";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public PID getPID() {
        return this.getTyped("PID", PID.class);
    }

    public PV1 getPV1() {
        return this.getTyped("PV1", PV1.class);
    }

    public FT1 getFT1() {
        return this.getTyped("FT1", FT1.class);
    }

    public FT1 getFT1(int rep) {
        return this.getTyped("FT1", rep, FT1.class);
    }

    public int getFT1Reps() {
        return this.getReps("FT1");
    }

    public List<FT1> getFT1All() throws HL7Exception {
        return this.getAllAsList("FT1", FT1.class);
    }

    public void insertFT1(FT1 structure, int rep) throws HL7Exception {
        super.insertRepetition("FT1", structure, rep);
    }

    public FT1 insertFT1(int rep) throws HL7Exception {
        return (FT1)super.insertRepetition("FT1", rep);
    }

    public FT1 removeFT1(int rep) throws HL7Exception {
        return (FT1)super.removeRepetition("FT1", rep);
    }
}

