/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CE;
import ca.uhn.hl7v2.model.v22.datatype.CM_LA1;
import ca.uhn.hl7v2.model.v22.datatype.CN;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.model.v22.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXA
extends AbstractSegment {
    public RXA(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NM.class, true, 1, 4, new Object[]{this.getMessage()}, "Give Sub-ID Counter");
            this.add(NM.class, true, 1, 4, new Object[]{this.getMessage()}, "Administration Sub-ID Counter");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Date / time start of administration");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Date / time end of administration");
            this.add(CE.class, true, 1, 100, new Object[]{this.getMessage()}, "Administered Code");
            this.add(NM.class, true, 1, 20, new Object[]{this.getMessage()}, "Administered Amount");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Administered Units");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Administered Dosage Form");
            this.add(ST.class, false, 1, 200, new Object[]{this.getMessage()}, "Administration Notes");
            this.add(CN.class, false, 1, 200, new Object[]{this.getMessage()}, "Administering Provider");
            this.add(CM_LA1.class, false, 1, 12, new Object[]{this.getMessage()}, "Administered-at Location");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Administered Per (Time Unit)");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXA - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public NM getGiveSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getRxa1_GiveSubIDCounter() {
        NM retVal = (NM)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getAdministrationSubIDCounter() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getRxa2_AdministrationSubIDCounter() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getDateTimeStartOfAdministration() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getRxa3_DateTimeStartOfAdministration() {
        TS retVal = (TS)this.getTypedField(3, 0);
        return retVal;
    }

    public TS getDateTimeEndOfAdministration() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public TS getRxa4_DateTimeEndOfAdministration() {
        TS retVal = (TS)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getAdministeredCode() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getRxa5_AdministeredCode() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getAdministeredAmount() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getRxa6_AdministeredAmount() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public CE getAdministeredUnits() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getRxa7_AdministeredUnits() {
        CE retVal = (CE)this.getTypedField(7, 0);
        return retVal;
    }

    public CE getAdministeredDosageForm() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public CE getRxa8_AdministeredDosageForm() {
        CE retVal = (CE)this.getTypedField(8, 0);
        return retVal;
    }

    public ST getAdministrationNotes() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public ST getRxa9_AdministrationNotes() {
        ST retVal = (ST)this.getTypedField(9, 0);
        return retVal;
    }

    public CN getAdministeringProvider() {
        CN retVal = (CN)this.getTypedField(10, 0);
        return retVal;
    }

    public CN getRxa10_AdministeringProvider() {
        CN retVal = (CN)this.getTypedField(10, 0);
        return retVal;
    }

    public CM_LA1 getAdministeredAtLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(11, 0);
        return retVal;
    }

    public CM_LA1 getRxa11_AdministeredAtLocation() {
        CM_LA1 retVal = (CM_LA1)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getAdministeredPerTimeUnit() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getRxa12_AdministeredPerTimeUnit() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new NM(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new TS(this.getMessage());
            }
            case 3: {
                return new TS(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new CE(this.getMessage());
            }
            case 7: {
                return new CE(this.getMessage());
            }
            case 8: {
                return new ST(this.getMessage());
            }
            case 9: {
                return new CN(this.getMessage());
            }
            case 10: {
                return new CM_LA1(this.getMessage());
            }
            case 11: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

