/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v22.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v22.datatype.CM_OCD;
import ca.uhn.hl7v2.model.v22.datatype.CM_UVC;
import ca.uhn.hl7v2.model.v22.datatype.DT;
import ca.uhn.hl7v2.model.v22.datatype.ID;
import ca.uhn.hl7v2.model.v22.datatype.NM;
import ca.uhn.hl7v2.model.v22.datatype.SI;
import ca.uhn.hl7v2.model.v22.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class UB1
extends AbstractSegment {
    public UB1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID - UB82");
            this.add(NM.class, false, 1, 1, new Object[]{this.getMessage()}, "Blood deductible (43)");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Blood furnished pints of (40)");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Blood replaced pints (41)");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Blood not replaced pints (42)");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Co-insurance days (25)");
            this.add(ID.class, false, 5, 2, new Object[]{this.getMessage(), new Integer(43)}, "Condition code (35-39)");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Covered days (23)");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Non-covered days (24)");
            this.add(CM_UVC.class, false, 8, 12, new Object[]{this.getMessage()}, "Value amount and code (46-49)");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Number of grace days (90)");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "Special program indicator (44)");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(0)}, "PSRO / UR approval indicator (87)");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "PSRO / UR approved stay - from (88)");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "PSRO / UR approved stay - to (89)");
            this.add(CM_OCD.class, false, 5, 20, new Object[]{this.getMessage()}, "Occurrence (28-32)");
            this.add(ID.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(0)}, "Occurrence span (33)");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Occurrence span start date (33)");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Occurrence span end date (33)");
            this.add(ST.class, false, 1, 30, new Object[]{this.getMessage()}, "UB-82 locator 2");
            this.add(ST.class, false, 1, 7, new Object[]{this.getMessage()}, "UB-82 locator 9");
            this.add(ST.class, false, 1, 8, new Object[]{this.getMessage()}, "UB-82 locator 27");
            this.add(ST.class, false, 1, 17, new Object[]{this.getMessage()}, "UB-82 locator 45");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating UB1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDUB82() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getUb11_SetIDUB82() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public NM getBloodDeductible() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getUb12_BloodDeductible() {
        NM retVal = (NM)this.getTypedField(2, 0);
        return retVal;
    }

    public NM getBloodFurnishedPintsOf() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getUb13_BloodFurnishedPintsOf() {
        NM retVal = (NM)this.getTypedField(3, 0);
        return retVal;
    }

    public NM getBloodReplacedPints() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getUb14_BloodReplacedPints() {
        NM retVal = (NM)this.getTypedField(4, 0);
        return retVal;
    }

    public NM getBloodNotReplacedPints() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getUb15_BloodNotReplacedPints() {
        NM retVal = (NM)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getCoInsuranceDays() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getUb16_CoInsuranceDays() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public ID[] getConditionCode3539() {
        ID[] retVal = (ID[])this.getTypedField(7, new ID[0]);
        return retVal;
    }

    public ID[] getUb17_ConditionCode3539() {
        ID[] retVal = (ID[])this.getTypedField(7, new ID[0]);
        return retVal;
    }

    public int getConditionCode3539Reps() {
        return this.getReps(7);
    }

    public ID getConditionCode3539(int rep) {
        ID retVal = (ID)this.getTypedField(7, rep);
        return retVal;
    }

    public ID getUb17_ConditionCode3539(int rep) {
        ID retVal = (ID)this.getTypedField(7, rep);
        return retVal;
    }

    public int getUb17_ConditionCode3539Reps() {
        return this.getReps(7);
    }

    public ID insertConditionCode3539(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(7, rep);
    }

    public ID insertUb17_ConditionCode3539(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(7, rep);
    }

    public ID removeConditionCode3539(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(7, rep);
    }

    public ID removeUb17_ConditionCode3539(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(7, rep);
    }

    public NM getCoveredDays() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getUb18_CoveredDays() {
        NM retVal = (NM)this.getTypedField(8, 0);
        return retVal;
    }

    public NM getNonCoveredDays() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public NM getUb19_NonCoveredDays() {
        NM retVal = (NM)this.getTypedField(9, 0);
        return retVal;
    }

    public CM_UVC[] getValueAmountAndCode4649() {
        CM_UVC[] retVal = (CM_UVC[])this.getTypedField(10, new CM_UVC[0]);
        return retVal;
    }

    public CM_UVC[] getUb110_ValueAmountAndCode4649() {
        CM_UVC[] retVal = (CM_UVC[])this.getTypedField(10, new CM_UVC[0]);
        return retVal;
    }

    public int getValueAmountAndCode4649Reps() {
        return this.getReps(10);
    }

    public CM_UVC getValueAmountAndCode4649(int rep) {
        CM_UVC retVal = (CM_UVC)this.getTypedField(10, rep);
        return retVal;
    }

    public CM_UVC getUb110_ValueAmountAndCode4649(int rep) {
        CM_UVC retVal = (CM_UVC)this.getTypedField(10, rep);
        return retVal;
    }

    public int getUb110_ValueAmountAndCode4649Reps() {
        return this.getReps(10);
    }

    public CM_UVC insertValueAmountAndCode4649(int rep) throws HL7Exception {
        return (CM_UVC)super.insertRepetition(10, rep);
    }

    public CM_UVC insertUb110_ValueAmountAndCode4649(int rep) throws HL7Exception {
        return (CM_UVC)super.insertRepetition(10, rep);
    }

    public CM_UVC removeValueAmountAndCode4649(int rep) throws HL7Exception {
        return (CM_UVC)super.removeRepetition(10, rep);
    }

    public CM_UVC removeUb110_ValueAmountAndCode4649(int rep) throws HL7Exception {
        return (CM_UVC)super.removeRepetition(10, rep);
    }

    public NM getNumberOfGraceDays() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public NM getUb111_NumberOfGraceDays() {
        NM retVal = (NM)this.getTypedField(11, 0);
        return retVal;
    }

    public ID getSpecialProgramIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getUb112_SpecialProgramIndicator() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getPSROURApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public ID getUb113_PSROURApprovalIndicator() {
        ID retVal = (ID)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getPSROURApprovedStayFrom() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public DT getUb114_PSROURApprovedStayFrom() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public DT getPSROURApprovedStayTo() {
        DT retVal = (DT)this.getTypedField(15, 0);
        return retVal;
    }

    public DT getUb115_PSROURApprovedStayTo() {
        DT retVal = (DT)this.getTypedField(15, 0);
        return retVal;
    }

    public CM_OCD[] getOccurrence2832() {
        CM_OCD[] retVal = (CM_OCD[])this.getTypedField(16, new CM_OCD[0]);
        return retVal;
    }

    public CM_OCD[] getUb116_Occurrence2832() {
        CM_OCD[] retVal = (CM_OCD[])this.getTypedField(16, new CM_OCD[0]);
        return retVal;
    }

    public int getOccurrence2832Reps() {
        return this.getReps(16);
    }

    public CM_OCD getOccurrence2832(int rep) {
        CM_OCD retVal = (CM_OCD)this.getTypedField(16, rep);
        return retVal;
    }

    public CM_OCD getUb116_Occurrence2832(int rep) {
        CM_OCD retVal = (CM_OCD)this.getTypedField(16, rep);
        return retVal;
    }

    public int getUb116_Occurrence2832Reps() {
        return this.getReps(16);
    }

    public CM_OCD insertOccurrence2832(int rep) throws HL7Exception {
        return (CM_OCD)super.insertRepetition(16, rep);
    }

    public CM_OCD insertUb116_Occurrence2832(int rep) throws HL7Exception {
        return (CM_OCD)super.insertRepetition(16, rep);
    }

    public CM_OCD removeOccurrence2832(int rep) throws HL7Exception {
        return (CM_OCD)super.removeRepetition(16, rep);
    }

    public CM_OCD removeUb116_Occurrence2832(int rep) throws HL7Exception {
        return (CM_OCD)super.removeRepetition(16, rep);
    }

    public ID getOccurrenceSpan() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public ID getUb117_OccurrenceSpan() {
        ID retVal = (ID)this.getTypedField(17, 0);
        return retVal;
    }

    public DT getOccurrenceSpanStartDate() {
        DT retVal = (DT)this.getTypedField(18, 0);
        return retVal;
    }

    public DT getUb118_OccurrenceSpanStartDate() {
        DT retVal = (DT)this.getTypedField(18, 0);
        return retVal;
    }

    public DT getOccurrenceSpanEndDate() {
        DT retVal = (DT)this.getTypedField(19, 0);
        return retVal;
    }

    public DT getUb119_OccurrenceSpanEndDate() {
        DT retVal = (DT)this.getTypedField(19, 0);
        return retVal;
    }

    public ST getUB82Locator2() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getUb120_UB82Locator2() {
        ST retVal = (ST)this.getTypedField(20, 0);
        return retVal;
    }

    public ST getUB82Locator9() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getUb121_UB82Locator9() {
        ST retVal = (ST)this.getTypedField(21, 0);
        return retVal;
    }

    public ST getUB82Locator27() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getUb122_UB82Locator27() {
        ST retVal = (ST)this.getTypedField(22, 0);
        return retVal;
    }

    public ST getUB82Locator45() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getUb123_UB82Locator45() {
        ST retVal = (ST)this.getTypedField(23, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new NM(this.getMessage());
            }
            case 2: {
                return new NM(this.getMessage());
            }
            case 3: {
                return new NM(this.getMessage());
            }
            case 4: {
                return new NM(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new ID(this.getMessage(), new Integer(43));
            }
            case 7: {
                return new NM(this.getMessage());
            }
            case 8: {
                return new NM(this.getMessage());
            }
            case 9: {
                return new CM_UVC(this.getMessage());
            }
            case 10: {
                return new NM(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 12: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 13: {
                return new DT(this.getMessage());
            }
            case 14: {
                return new DT(this.getMessage());
            }
            case 15: {
                return new CM_OCD(this.getMessage());
            }
            case 16: {
                return new ID(this.getMessage(), new Integer(0));
            }
            case 17: {
                return new DT(this.getMessage());
            }
            case 18: {
                return new DT(this.getMessage());
            }
            case 19: {
                return new ST(this.getMessage());
            }
            case 20: {
                return new ST(this.getMessage());
            }
            case 21: {
                return new ST(this.getMessage());
            }
            case 22: {
                return new ST(this.getMessage());
            }
        }
        return null;
    }
}

