/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v251.group.RAS_O17_ADMINISTRATION;
import ca.uhn.hl7v2.model.v251.group.RAS_O17_ENCODING;
import ca.uhn.hl7v2.model.v251.group.RAS_O17_ORDER_DETAIL;
import ca.uhn.hl7v2.model.v251.group.RAS_O17_TIMING;
import ca.uhn.hl7v2.model.v251.segment.CTI;
import ca.uhn.hl7v2.model.v251.segment.ORC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RAS_O17_ORDER
extends AbstractGroup {
    public RAS_O17_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(RAS_O17_TIMING.class, false, true, false);
            this.add(RAS_O17_ORDER_DETAIL.class, false, false, false);
            this.add(RAS_O17_ENCODING.class, false, false, false);
            this.add(RAS_O17_ADMINISTRATION.class, true, true, false);
            this.add(CTI.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RAS_O17_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5.1";
    }

    public ORC getORC() {
        ORC retVal = this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public RAS_O17_TIMING getTIMING() {
        RAS_O17_TIMING retVal = this.getTyped("TIMING", RAS_O17_TIMING.class);
        return retVal;
    }

    public RAS_O17_TIMING getTIMING(int rep) {
        RAS_O17_TIMING retVal = this.getTyped("TIMING", rep, RAS_O17_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<RAS_O17_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", RAS_O17_TIMING.class);
    }

    public void insertTIMING(RAS_O17_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", structure, rep);
    }

    public RAS_O17_TIMING insertTIMING(int rep) throws HL7Exception {
        return (RAS_O17_TIMING)super.insertRepetition("TIMING", rep);
    }

    public RAS_O17_TIMING removeTIMING(int rep) throws HL7Exception {
        return (RAS_O17_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RAS_O17_ORDER_DETAIL getORDER_DETAIL() {
        RAS_O17_ORDER_DETAIL retVal = this.getTyped("ORDER_DETAIL", RAS_O17_ORDER_DETAIL.class);
        return retVal;
    }

    public RAS_O17_ENCODING getENCODING() {
        RAS_O17_ENCODING retVal = this.getTyped("ENCODING", RAS_O17_ENCODING.class);
        return retVal;
    }

    public RAS_O17_ADMINISTRATION getADMINISTRATION() {
        RAS_O17_ADMINISTRATION retVal = this.getTyped("ADMINISTRATION", RAS_O17_ADMINISTRATION.class);
        return retVal;
    }

    public RAS_O17_ADMINISTRATION getADMINISTRATION(int rep) {
        RAS_O17_ADMINISTRATION retVal = this.getTyped("ADMINISTRATION", rep, RAS_O17_ADMINISTRATION.class);
        return retVal;
    }

    public int getADMINISTRATIONReps() {
        return this.getReps("ADMINISTRATION");
    }

    public List<RAS_O17_ADMINISTRATION> getADMINISTRATIONAll() throws HL7Exception {
        return this.getAllAsList("ADMINISTRATION", RAS_O17_ADMINISTRATION.class);
    }

    public void insertADMINISTRATION(RAS_O17_ADMINISTRATION structure, int rep) throws HL7Exception {
        super.insertRepetition("ADMINISTRATION", structure, rep);
    }

    public RAS_O17_ADMINISTRATION insertADMINISTRATION(int rep) throws HL7Exception {
        return (RAS_O17_ADMINISTRATION)super.insertRepetition("ADMINISTRATION", rep);
    }

    public RAS_O17_ADMINISTRATION removeADMINISTRATION(int rep) throws HL7Exception {
        return (RAS_O17_ADMINISTRATION)super.removeRepetition("ADMINISTRATION", rep);
    }

    public CTI getCTI() {
        CTI retVal = this.getTyped("CTI", CTI.class);
        return retVal;
    }

    public CTI getCTI(int rep) {
        CTI retVal = this.getTyped("CTI", rep, CTI.class);
        return retVal;
    }

    public int getCTIReps() {
        return this.getReps("CTI");
    }

    public List<CTI> getCTIAll() throws HL7Exception {
        return this.getAllAsList("CTI", CTI.class);
    }

    public void insertCTI(CTI structure, int rep) throws HL7Exception {
        super.insertRepetition("CTI", structure, rep);
    }

    public CTI insertCTI(int rep) throws HL7Exception {
        return (CTI)super.insertRepetition("CTI", rep);
    }

    public CTI removeCTI(int rep) throws HL7Exception {
        return (CTI)super.removeRepetition("CTI", rep);
    }
}

