/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DR;
import ca.uhn.hl7v2.model.v26.datatype.DTM;
import ca.uhn.hl7v2.model.v26.datatype.EI;
import ca.uhn.hl7v2.model.v26.datatype.ID;
import ca.uhn.hl7v2.model.v26.datatype.IS;
import ca.uhn.hl7v2.model.v26.datatype.NM;
import ca.uhn.hl7v2.model.v26.datatype.SAD;
import ca.uhn.hl7v2.model.v26.datatype.ST;

public class XAD
extends AbstractComposite {
    private Type[] data;

    public XAD(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[23];
        this.data[0] = new SAD(this.getMessage());
        this.data[1] = new ST(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ID(this.getMessage(), 399);
        this.data[6] = new ID(this.getMessage(), 190);
        this.data[7] = new ST(this.getMessage());
        this.data[8] = new IS(this.getMessage(), 289);
        this.data[9] = new IS(this.getMessage(), 288);
        this.data[10] = new ID(this.getMessage(), 465);
        this.data[11] = new DR(this.getMessage());
        this.data[12] = new DTM(this.getMessage());
        this.data[13] = new DTM(this.getMessage());
        this.data[14] = new CWE(this.getMessage());
        this.data[15] = new ID(this.getMessage(), 136);
        this.data[16] = new ID(this.getMessage(), 136);
        this.data[17] = new ID(this.getMessage(), 617);
        this.data[18] = new ST(this.getMessage());
        this.data[19] = new ST(this.getMessage());
        this.data[20] = new NM(this.getMessage());
        this.data[21] = new CWE(this.getMessage());
        this.data[22] = new EI(this.getMessage());
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + this.getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public SAD getStreetAddress() {
        return this.getTyped(0, SAD.class);
    }

    public SAD getXad1_StreetAddress() {
        return this.getTyped(0, SAD.class);
    }

    public ST getOtherDesignation() {
        return this.getTyped(1, ST.class);
    }

    public ST getXad2_OtherDesignation() {
        return this.getTyped(1, ST.class);
    }

    public ST getCity() {
        return this.getTyped(2, ST.class);
    }

    public ST getXad3_City() {
        return this.getTyped(2, ST.class);
    }

    public ST getStateOrProvince() {
        return this.getTyped(3, ST.class);
    }

    public ST getXad4_StateOrProvince() {
        return this.getTyped(3, ST.class);
    }

    public ST getZipOrPostalCode() {
        return this.getTyped(4, ST.class);
    }

    public ST getXad5_ZipOrPostalCode() {
        return this.getTyped(4, ST.class);
    }

    public ID getCountry() {
        return this.getTyped(5, ID.class);
    }

    public ID getXad6_Country() {
        return this.getTyped(5, ID.class);
    }

    public ID getAddressType() {
        return this.getTyped(6, ID.class);
    }

    public ID getXad7_AddressType() {
        return this.getTyped(6, ID.class);
    }

    public ST getOtherGeographicDesignation() {
        return this.getTyped(7, ST.class);
    }

    public ST getXad8_OtherGeographicDesignation() {
        return this.getTyped(7, ST.class);
    }

    public IS getCountyParishCode() {
        return this.getTyped(8, IS.class);
    }

    public IS getXad9_CountyParishCode() {
        return this.getTyped(8, IS.class);
    }

    public IS getCensusTract() {
        return this.getTyped(9, IS.class);
    }

    public IS getXad10_CensusTract() {
        return this.getTyped(9, IS.class);
    }

    public ID getAddressRepresentationCode() {
        return this.getTyped(10, ID.class);
    }

    public ID getXad11_AddressRepresentationCode() {
        return this.getTyped(10, ID.class);
    }

    public DR getAddressValidityRange() {
        return this.getTyped(11, DR.class);
    }

    public DR getXad12_AddressValidityRange() {
        return this.getTyped(11, DR.class);
    }

    public DTM getEffectiveDate() {
        return this.getTyped(12, DTM.class);
    }

    public DTM getXad13_EffectiveDate() {
        return this.getTyped(12, DTM.class);
    }

    public DTM getExpirationDate() {
        return this.getTyped(13, DTM.class);
    }

    public DTM getXad14_ExpirationDate() {
        return this.getTyped(13, DTM.class);
    }

    public CWE getExpirationReason() {
        return this.getTyped(14, CWE.class);
    }

    public CWE getXad15_ExpirationReason() {
        return this.getTyped(14, CWE.class);
    }

    public ID getTemporaryIndicator() {
        return this.getTyped(15, ID.class);
    }

    public ID getXad16_TemporaryIndicator() {
        return this.getTyped(15, ID.class);
    }

    public ID getBadAddressIndicator() {
        return this.getTyped(16, ID.class);
    }

    public ID getXad17_BadAddressIndicator() {
        return this.getTyped(16, ID.class);
    }

    public ID getAddressUsage() {
        return this.getTyped(17, ID.class);
    }

    public ID getXad18_AddressUsage() {
        return this.getTyped(17, ID.class);
    }

    public ST getAddressee() {
        return this.getTyped(18, ST.class);
    }

    public ST getXad19_Addressee() {
        return this.getTyped(18, ST.class);
    }

    public ST getComment() {
        return this.getTyped(19, ST.class);
    }

    public ST getXad20_Comment() {
        return this.getTyped(19, ST.class);
    }

    public NM getPreferenceOrder() {
        return this.getTyped(20, NM.class);
    }

    public NM getXad21_PreferenceOrder() {
        return this.getTyped(20, NM.class);
    }

    public CWE getProtectionCode() {
        return this.getTyped(21, CWE.class);
    }

    public CWE getXad22_ProtectionCode() {
        return this.getTyped(21, CWE.class);
    }

    public EI getAddressIdentifier() {
        return this.getTyped(22, EI.class);
    }

    public EI getXad23_AddressIdentifier() {
        return this.getTyped(22, EI.class);
    }
}

