/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_ORDER_PRIOR;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_PATIENT_PRIOR;
import ca.uhn.hl7v2.model.v26.group.OPL_O37_PATIENT_VISIT_PRIOR;
import ca.uhn.hl7v2.model.v26.segment.AL1;
import ca.uhn.hl7v2.model.v26.segment.NK1;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPL_O37_PRIOR_RESULT
extends AbstractGroup {
    public OPL_O37_PRIOR_RESULT(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(NK1.class, true, true, false);
            this.add(OPL_O37_PATIENT_PRIOR.class, false, false, false);
            this.add(OPL_O37_PATIENT_VISIT_PRIOR.class, false, false, false);
            this.add(AL1.class, false, false, false);
            this.add(OPL_O37_ORDER_PRIOR.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OPL_O37_PRIOR_RESULT - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public NK1 getNK1() {
        NK1 retVal = this.getTyped("NK1", NK1.class);
        return retVal;
    }

    public NK1 getNK1(int rep) {
        NK1 retVal = this.getTyped("NK1", rep, NK1.class);
        return retVal;
    }

    public int getNK1Reps() {
        return this.getReps("NK1");
    }

    public List<NK1> getNK1All() throws HL7Exception {
        return this.getAllAsList("NK1", NK1.class);
    }

    public void insertNK1(NK1 structure, int rep) throws HL7Exception {
        super.insertRepetition("NK1", structure, rep);
    }

    public NK1 insertNK1(int rep) throws HL7Exception {
        return (NK1)super.insertRepetition("NK1", rep);
    }

    public NK1 removeNK1(int rep) throws HL7Exception {
        return (NK1)super.removeRepetition("NK1", rep);
    }

    public OPL_O37_PATIENT_PRIOR getPATIENT_PRIOR() {
        OPL_O37_PATIENT_PRIOR retVal = this.getTyped("PATIENT_PRIOR", OPL_O37_PATIENT_PRIOR.class);
        return retVal;
    }

    public OPL_O37_PATIENT_VISIT_PRIOR getPATIENT_VISIT_PRIOR() {
        OPL_O37_PATIENT_VISIT_PRIOR retVal = this.getTyped("PATIENT_VISIT_PRIOR", OPL_O37_PATIENT_VISIT_PRIOR.class);
        return retVal;
    }

    public AL1 getAL1() {
        AL1 retVal = this.getTyped("AL1", AL1.class);
        return retVal;
    }

    public OPL_O37_ORDER_PRIOR getORDER_PRIOR() {
        OPL_O37_ORDER_PRIOR retVal = this.getTyped("ORDER_PRIOR", OPL_O37_ORDER_PRIOR.class);
        return retVal;
    }

    public OPL_O37_ORDER_PRIOR getORDER_PRIOR(int rep) {
        OPL_O37_ORDER_PRIOR retVal = this.getTyped("ORDER_PRIOR", rep, OPL_O37_ORDER_PRIOR.class);
        return retVal;
    }

    public int getORDER_PRIORReps() {
        return this.getReps("ORDER_PRIOR");
    }

    public List<OPL_O37_ORDER_PRIOR> getORDER_PRIORAll() throws HL7Exception {
        return this.getAllAsList("ORDER_PRIOR", OPL_O37_ORDER_PRIOR.class);
    }

    public void insertORDER_PRIOR(OPL_O37_ORDER_PRIOR structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER_PRIOR", structure, rep);
    }

    public OPL_O37_ORDER_PRIOR insertORDER_PRIOR(int rep) throws HL7Exception {
        return (OPL_O37_ORDER_PRIOR)super.insertRepetition("ORDER_PRIOR", rep);
    }

    public OPL_O37_ORDER_PRIOR removeORDER_PRIOR(int rep) throws HL7Exception {
        return (OPL_O37_ORDER_PRIOR)super.removeRepetition("ORDER_PRIOR", rep);
    }
}

