/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v26.datatype.CNE;
import ca.uhn.hl7v2.model.v26.datatype.CWE;
import ca.uhn.hl7v2.model.v26.datatype.DR;
import ca.uhn.hl7v2.model.v26.datatype.SI;
import ca.uhn.hl7v2.model.v26.datatype.ST;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class ARV
extends AbstractSegment {
    public ARV(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, false, 1, 4, new Object[]{this.getMessage()}, "Set ID");
            this.add(CNE.class, true, 1, 705, new Object[]{this.getMessage()}, "Access Restriction Action Code");
            this.add(CWE.class, true, 1, 705, new Object[]{this.getMessage()}, "Access Restriction Value");
            this.add(CWE.class, false, 0, 705, new Object[]{this.getMessage()}, "Access Restriction Reason");
            this.add(ST.class, false, 0, 250, new Object[]{this.getMessage()}, "Special Access Restriction Instructions");
            this.add(DR.class, false, 1, 49, new Object[]{this.getMessage()}, "Access Restriction Date Range");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating ARV - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetID() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getArv1_SetID() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CNE getAccessRestrictionActionCode() {
        CNE retVal = (CNE)this.getTypedField(2, 0);
        return retVal;
    }

    public CNE getArv2_AccessRestrictionActionCode() {
        CNE retVal = (CNE)this.getTypedField(2, 0);
        return retVal;
    }

    public CWE getAccessRestrictionValue() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE getArv3_AccessRestrictionValue() {
        CWE retVal = (CWE)this.getTypedField(3, 0);
        return retVal;
    }

    public CWE[] getAccessRestrictionReason() {
        CWE[] retVal = (CWE[])this.getTypedField(4, new CWE[0]);
        return retVal;
    }

    public CWE[] getArv4_AccessRestrictionReason() {
        CWE[] retVal = (CWE[])this.getTypedField(4, new CWE[0]);
        return retVal;
    }

    public int getAccessRestrictionReasonReps() {
        return this.getReps(4);
    }

    public CWE getAccessRestrictionReason(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public CWE getArv4_AccessRestrictionReason(int rep) {
        CWE retVal = (CWE)this.getTypedField(4, rep);
        return retVal;
    }

    public int getArv4_AccessRestrictionReasonReps() {
        return this.getReps(4);
    }

    public CWE insertAccessRestrictionReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE insertArv4_AccessRestrictionReason(int rep) throws HL7Exception {
        return (CWE)super.insertRepetition(4, rep);
    }

    public CWE removeAccessRestrictionReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public CWE removeArv4_AccessRestrictionReason(int rep) throws HL7Exception {
        return (CWE)super.removeRepetition(4, rep);
    }

    public ST[] getSpecialAccessRestrictionInstructions() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public ST[] getArv5_SpecialAccessRestrictionInstructions() {
        ST[] retVal = (ST[])this.getTypedField(5, new ST[0]);
        return retVal;
    }

    public int getSpecialAccessRestrictionInstructionsReps() {
        return this.getReps(5);
    }

    public ST getSpecialAccessRestrictionInstructions(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public ST getArv5_SpecialAccessRestrictionInstructions(int rep) {
        ST retVal = (ST)this.getTypedField(5, rep);
        return retVal;
    }

    public int getArv5_SpecialAccessRestrictionInstructionsReps() {
        return this.getReps(5);
    }

    public ST insertSpecialAccessRestrictionInstructions(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST insertArv5_SpecialAccessRestrictionInstructions(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(5, rep);
    }

    public ST removeSpecialAccessRestrictionInstructions(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public ST removeArv5_SpecialAccessRestrictionInstructions(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(5, rep);
    }

    public DR getAccessRestrictionDateRange() {
        DR retVal = (DR)this.getTypedField(6, 0);
        return retVal;
    }

    public DR getArv6_AccessRestrictionDateRange() {
        DR retVal = (DR)this.getTypedField(6, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CNE(this.getMessage());
            }
            case 2: {
                return new CWE(this.getMessage());
            }
            case 3: {
                return new CWE(this.getMessage());
            }
            case 4: {
                return new ST(this.getMessage());
            }
            case 5: {
                return new DR(this.getMessage());
            }
        }
        return null;
    }
}

