/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.validation.PrimitiveTypeRule;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.builder.Predicate;
import ca.uhn.hl7v2.validation.builder.PredicatePrimitiveTypeRule;
import ca.uhn.hl7v2.validation.builder.RuleTypeBuilder;
import ca.uhn.hl7v2.validation.impl.PrimitiveTypeRuleBinding;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveRuleBuilder
extends RuleTypeBuilder<PrimitiveRuleBuilder, PrimitiveTypeRule> {
    private Set<String> types;

    protected PrimitiveRuleBuilder(List<RuleBinding<? extends Rule<?>>> rules, Set<Version> versions, Set<String> types) {
        super(rules, versions);
        this.types = types;
    }

    public PrimitiveRuleBuilder is(Predicate predicate) {
        return (PrimitiveRuleBuilder)this.test(this.prepareRule(new PredicatePrimitiveTypeRule(predicate)));
    }

    public PrimitiveRuleBuilder leftTrim(Predicate predicate) {
        return (PrimitiveRuleBuilder)this.test(this.prepareRule(new PredicatePrimitiveTypeRule(predicate, PredicatePrimitiveTypeRule.Trimmer.LEFT)));
    }

    public PrimitiveRuleBuilder leftTrim() {
        return this.leftTrim(this.always(true));
    }

    public PrimitiveRuleBuilder rightTrim() {
        return this.rightTrim(this.always(true));
    }

    public PrimitiveRuleBuilder rightTrim(Predicate predicate) {
        return (PrimitiveRuleBuilder)this.test(this.prepareRule(new PredicatePrimitiveTypeRule(predicate, PredicatePrimitiveTypeRule.Trimmer.RIGHT)));
    }

    public PrimitiveRuleBuilder allTrim() {
        return this.allTrim(this.always(true));
    }

    public PrimitiveRuleBuilder allTrim(Predicate predicate) {
        return (PrimitiveRuleBuilder)this.test(this.prepareRule(new PredicatePrimitiveTypeRule(predicate, PredicatePrimitiveTypeRule.Trimmer.ALL)));
    }

    @Override
    protected Collection<RuleBinding<PrimitiveTypeRule>> getRuleBindings(PrimitiveTypeRule rule, String version) {
        ArrayList bindings = new ArrayList();
        for (String type : this.types) {
            bindings.add(new PrimitiveTypeRuleBinding(version, type, rule));
        }
        return this.activate(bindings);
    }

    Set<String> getTypes() {
        return this.types;
    }
}

