/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.jaxrs.ext.search.Beanspector;
import org.apache.cxf.jaxrs.ext.search.InterfaceProxy;
import org.apache.cxf.jaxrs.ext.search.PropertyNotFoundException;
import org.apache.cxf.jaxrs.ext.search.SearchBean;
import org.apache.cxf.jaxrs.ext.search.SearchConditionParser;
import org.apache.cxf.jaxrs.ext.search.SearchParseException;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.collections.CollectionCheck;
import org.apache.cxf.jaxrs.ext.search.collections.CollectionCheckInfo;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;

public abstract class AbstractSearchConditionParser<T>
implements SearchConditionParser<T> {
    protected final Map<String, String> contextProperties;
    protected final Class<T> conditionClass;
    protected Beanspector<T> beanspector;
    protected Map<String, String> beanPropertiesMap;

    protected AbstractSearchConditionParser(Class<T> tclass) {
        this(tclass, Collections.emptyMap(), null);
    }

    protected AbstractSearchConditionParser(Class<T> tclass, Map<String, String> contextProperties, Map<String, String> beanProperties) {
        this.conditionClass = tclass;
        this.contextProperties = contextProperties == null ? Collections.emptyMap() : contextProperties;
        this.beanspector = SearchBean.class.isAssignableFrom(tclass) ? null : new Beanspector<Class<Class<Class<Class<T>>>>>(tclass);
        this.beanPropertiesMap = beanProperties;
    }

    protected String getActualSetterName(String setter) {
        String beanPropertyName = this.beanPropertiesMap == null ? null : this.beanPropertiesMap.get(setter);
        return beanPropertyName != null ? beanPropertyName : setter;
    }

    protected Boolean isDecodeQueryValues() {
        return PropertyUtils.isTrue((Object)this.contextProperties.get("search.decode.values"));
    }

    protected Beanspector.TypeInfo getTypeInfo(String setter, String value) throws SearchParseException, PropertyNotFoundException {
        String name = this.getSetter(setter);
        Beanspector.TypeInfo typeInfo = null;
        try {
            typeInfo = this.beanspector != null ? this.beanspector.getAccessorTypeInfo(name) : new Beanspector.TypeInfo(String.class, (Type)((Object)String.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (typeInfo == null && !MessageUtils.isTrue((Object)this.contextProperties.get("search.lax.property.match"))) {
            throw new PropertyNotFoundException(name, value);
        }
        return typeInfo;
    }

    protected String getSetter(String setter) {
        int index = this.getDotIndex(setter);
        if (index != -1) {
            return setter.substring(0, index).toLowerCase();
        }
        return setter;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected Object parseType(String originalPropName, Object ownerBean, Object lastCastedValue, String setter, Beanspector.TypeInfo typeInfo, String value) throws SearchParseException {
        valueType = typeInfo.getTypeClass();
        isCollection = InjectionUtils.isSupportedCollectionOrArray(valueType);
        actualType = isCollection != false ? InjectionUtils.getActualType((Type)typeInfo.getGenericType()) : valueType;
        index = this.getDotIndex(setter);
        if (index == -1) {
            castedValue = value;
            if (Date.class.isAssignableFrom(valueType)) {
                castedValue = this.convertToDate(valueType, value);
            } else {
                isPrimitive = InjectionUtils.isPrimitive((Class)valueType);
                v0 = isPrimitiveOrEnum = isPrimitive != false || valueType.isEnum() != false;
                if (ownerBean == null || isPrimitiveOrEnum) {
                    try {
                        collCheck = this.getCollectionCheck(originalPropName, isCollection, actualType);
                        if (collCheck == null) {
                            castedValue = InjectionUtils.convertStringToPrimitive((String)value, actualType);
                        }
                        if (collCheck == null && isCollection) {
                            castedValue = this.getCollectionSingleton(valueType, castedValue);
                        }
                        if (!isCollection) ** GOTO lbl36
                        typeInfo.setCollectionCheckInfo(new CollectionCheckInfo(collCheck, castedValue));
                        castedValue = this.getEmptyCollection(valueType);
                    }
                    catch (Exception e) {
                        throw new SearchParseException("Cannot convert String value \"" + value + "\" to a value of class " + valueType.getName(), e);
                    }
                } else {
                    classType = isCollection != false ? valueType : value.getClass();
                    try {
                        setterM = valueType.getMethod("set" + this.getMethodNameSuffix(setter), new Class[]{classType});
                        objectValue = isCollection == false ? value : this.getCollectionSingleton(valueType, value);
                        setterM.invoke(ownerBean, new Object[]{objectValue});
                        castedValue = objectValue;
                    }
                    catch (Throwable ex) {
                        throw new SearchParseException("Cannot convert String value \"" + value + "\" to a value of class " + valueType.getName(), ex);
                    }
                }
            }
lbl36:
            // 5 sources

            if (lastCastedValue != null) {
                castedValue = lastCastedValue;
            }
            return castedValue;
        }
        names = setter.split("\\.");
        try {
            nextPart = this.getMethodNameSuffix(names[1]);
            getterM = actualType.getMethod("get" + nextPart, new Class[0]);
            returnType = getterM.getReturnType();
            returnCollection = InjectionUtils.isSupportedCollectionOrArray(returnType);
            actualReturnType = returnCollection == false ? returnType : InjectionUtils.getActualType((Type)getterM.getGenericReturnType());
            isPrimitive = returnCollection == false && InjectionUtils.isPrimitive((Class)returnType) != false || returnType.isEnum() != false;
            v1 = lastTry = names.length == 2 && (isPrimitive != false || Date.class.isAssignableFrom(returnType) != false || returnCollection != false);
            v2 = ownerBean != null ? ownerBean : (valueObject = actualType.isInterface() != false ? Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{actualType}, (InvocationHandler)new InterfaceProxy()) : actualType.newInstance());
            if (lastTry) {
                if (!returnCollection) {
                    nextObject /* !! */  = isPrimitive != false ? InjectionUtils.convertStringToPrimitive((String)value, (Class)returnType) : this.convertToDate(returnType, value);
                } else {
                    collCheck = this.getCollectionCheck(originalPropName, true, actualReturnType);
                    if (collCheck == null) {
                        nextObject /* !! */  = this.getCollectionSingleton(valueType, value);
                    } else {
                        typeInfo.setCollectionCheckInfo(new CollectionCheckInfo(collCheck, value));
                        nextObject /* !! */  = this.getEmptyCollection(valueType);
                    }
                }
            } else {
                nextObject /* !! */  = returnCollection == false ? returnType.newInstance() : actualReturnType.newInstance();
            }
            setterM = actualType.getMethod("set" + nextPart, new Class[]{returnType});
            valueObjectValue = lastTry != false || returnCollection == false ? nextObject /* !! */  : this.getCollectionSingleton(valueType, nextObject /* !! */ );
            setterM.invoke(valueObject, new Object[]{valueObjectValue});
            if (lastTry) {
                lastCastedValue = lastCastedValue == null ? valueObject : lastCastedValue;
                return isCollection != false ? this.getCollectionSingleton(valueType, lastCastedValue) : lastCastedValue;
            }
            lastCastedValue = valueObject;
            nextTypeInfo = new Beanspector.TypeInfo(valueObjectValue.getClass(), getterM.getGenericReturnType());
            response = this.parseType(originalPropName, nextObject /* !! */ , lastCastedValue, setter.substring(index + 1), nextTypeInfo, value);
            if (ownerBean == null) {
                return isCollection != false ? this.getCollectionSingleton(valueType, lastCastedValue) : lastCastedValue;
            }
            return response;
        }
        catch (Throwable e) {
            throw new SearchParseException("Cannot convert String value \"" + value + "\" to a value of class " + valueType.getName(), e);
        }
    }

    private CollectionCheck getCollectionCheck(String propName, boolean isCollection, Class<?> actualCls) {
        if (isCollection) {
            if (InjectionUtils.isPrimitive(actualCls)) {
                if (this.isCount(propName)) {
                    return CollectionCheck.SIZE;
                }
            } else {
                return CollectionCheck.SIZE;
            }
        }
        return null;
    }

    protected boolean isCount(String propName) {
        return false;
    }

    private Object getCollectionSingleton(Class<?> collectionCls, Object value) {
        if (Set.class.isAssignableFrom(collectionCls)) {
            return Collections.singleton(value);
        }
        return Collections.singletonList(value);
    }

    private Object getEmptyCollection(Class<?> collectionCls) {
        if (Set.class.isAssignableFrom(collectionCls)) {
            return Collections.emptySet();
        }
        return Collections.emptyList();
    }

    private Object convertToDate(Class<?> valueType, String value) throws SearchParseException {
        Message m = JAXRSUtils.getCurrentMessage();
        Object obj = InjectionUtils.createFromParameterHandler((String)value, valueType, valueType, (Annotation[])new Annotation[0], (Message)m);
        if (obj != null) {
            return obj;
        }
        try {
            if (Timestamp.class.isAssignableFrom(valueType)) {
                return this.convertToTimestamp(value);
            }
            if (Time.class.isAssignableFrom(valueType)) {
                return this.convertToTime(value);
            }
            return this.convertToDefaultDate(value);
        }
        catch (ParseException e) {
            try {
                Date now = new Date();
                DatatypeFactory.newInstance().newDuration(value).addTo(now);
                return now;
            }
            catch (DatatypeConfigurationException e1) {
                throw new SearchParseException(e1);
            }
            catch (IllegalArgumentException e1) {
                throw new SearchParseException("Can parse " + value + " neither as date nor duration", e);
            }
        }
    }

    private Timestamp convertToTimestamp(String value) throws ParseException {
        Date date = this.convertToDefaultDate(value);
        return new Timestamp(date.getTime());
    }

    private Time convertToTime(String value) throws ParseException {
        Date date = this.convertToDefaultDate(value);
        return new Time(date.getTime());
    }

    private Date convertToDefaultDate(String value) throws ParseException {
        int idx;
        SimpleDateFormat df = SearchUtils.getDateFormat(this.contextProperties);
        String dateValue = value;
        if (SearchUtils.isTimeZoneSupported(this.contextProperties, Boolean.FALSE) && (idx = value.lastIndexOf(58)) != -1) {
            dateValue = value.substring(0, idx) + value.substring(idx + 1);
        }
        return df.parse(dateValue);
    }

    private String getMethodNameSuffix(String name) {
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private int getDotIndex(String setter) {
        return this.conditionClass == SearchBean.class ? -1 : setter.indexOf(".");
    }
}

