/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.processor.ThrowExceptionProcessor;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="error")
@XmlRootElement(name="throwException")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ThrowExceptionDefinition
extends NoOutputDefinition<ThrowExceptionDefinition> {
    @XmlAttribute(required=true)
    private String ref;
    @XmlTransient
    private Exception exception;

    public String toString() {
        return "ThrowException[" + this.description() + "]";
    }

    protected String description() {
        return this.exception != null ? this.exception.getClass().getCanonicalName() : "ref:" + this.ref;
    }

    @Override
    public String getLabel() {
        return "throwException[" + this.description() + "]";
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) {
        if (this.ref != null && this.exception == null) {
            this.exception = routeContext.getCamelContext().getRegistry().lookupByNameAndType(this.ref, Exception.class);
        }
        ObjectHelper.notNull(this.exception, "exception or ref", this);
        return new ThrowExceptionProcessor(this.exception);
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }
}

