/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.impl.DefaultModelJAXBContextFactory;
import org.apache.camel.main.MainSupport;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.CdiContainerLoader;
import org.apache.deltaspike.core.api.provider.BeanProvider;

public abstract class Main
extends MainSupport {
    private static Main instance;
    private JAXBContext jaxbContext;
    private Object cdiContainer;

    public static void main(String ... args) throws Exception {
        Main main;
        instance = main = new Main(){};
        main.enableHangupSupport();
        main.run(args);
    }

    public static Main getInstance() {
        return instance;
    }

    protected ProducerTemplate findOrCreateCamelTemplate() {
        ProducerTemplate answer = (ProducerTemplate)BeanProvider.getContextualReference(ProducerTemplate.class, (boolean)true, (Annotation[])new Annotation[0]);
        if (answer != null) {
            return answer;
        }
        if (this.getCamelContexts().isEmpty()) {
            throw new IllegalArgumentException("No CamelContexts are available so cannot create a ProducerTemplate!");
        }
        return ((CamelContext)this.getCamelContexts().get(0)).createProducerTemplate();
    }

    protected Map<String, CamelContext> getCamelContextMap() {
        List contexts = BeanProvider.getContextualReferences(CamelContext.class, (boolean)true);
        HashMap<String, CamelContext> answer = new HashMap<String, CamelContext>();
        for (CamelContext context : contexts) {
            String name = context.getName();
            answer.put(name, context);
        }
        return answer;
    }

    public ModelJAXBContextFactory getModelJAXBContextFactory() {
        return new DefaultModelJAXBContextFactory();
    }

    protected void doStart() throws Exception {
        CdiContainer container = CdiContainerLoader.getCdiContainer();
        container.boot();
        container.getContextControl().startContexts();
        this.cdiContainer = container;
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.cdiContainer != null) {
            ((CdiContainer)this.cdiContainer).shutdown();
        }
    }
}

