/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.util;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import org.ops4j.pax.cdi.extension.impl.util.WrappedAnnotatedType;

public class AnnotatedTypeWrapper<T>
extends WrappedAnnotatedType<T> {
    private AnnotatedType<T> delegate;
    private Set<Annotation> annotations;

    public AnnotatedTypeWrapper(AnnotatedType<T> delegate, Annotation ... additionalAnnotations) {
        this.delegate = delegate;
        this.annotations = new HashSet<Annotation>(delegate.getAnnotations());
        for (Annotation annotation : additionalAnnotations) {
            this.annotations.add(annotation);
        }
        this.annotations = Collections.unmodifiableSet(this.annotations);
    }

    @Override
    public AnnotatedType<T> delegate() {
        return this.delegate;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (A)annotation;
        }
        return null;
    }

    @Override
    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getAnnotation(annotationType) != null;
    }
}

