/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.weld.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jboss.weld.bootstrap.api.SingletonProvider;
import org.jboss.weld.bootstrap.api.helpers.RegistrySingletonProvider;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.CdiContainerFactory;
import org.ops4j.pax.cdi.spi.CdiContainerListener;
import org.ops4j.pax.cdi.spi.CdiContainerType;
import org.ops4j.pax.cdi.weld.impl.WeldCdiContainer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeldCdiContainerFactory
implements CdiContainerFactory {
    private Logger log = LoggerFactory.getLogger(WeldCdiContainerFactory.class);
    private Map<Long, CdiContainer> containers = new HashMap<Long, CdiContainer>();
    private List<CdiContainerListener> listeners = new CopyOnWriteArrayList<CdiContainerListener>();
    private BundleContext bundleContext;

    public void activate(BundleContext bc) {
        this.bundleContext = bc;
        SingletonProvider.initialize((SingletonProvider)new RegistrySingletonProvider());
    }

    public void deactivate() {
        SingletonProvider.reset();
    }

    public String getProviderName() {
        return "Weld";
    }

    public CdiContainer createContainer(Bundle bundle, Collection<Bundle> extensions, CdiContainerType containerType) {
        WeldCdiContainer container = new WeldCdiContainer(containerType, this.bundleContext.getBundle(), bundle, extensions);
        this.containers.put(bundle.getBundleId(), (CdiContainer)container);
        for (CdiContainerListener listener : this.listeners) {
            listener.postCreate((CdiContainer)container);
        }
        this.log.debug("Weld Container created");
        return container;
    }

    public CdiContainer getContainer(Bundle bundle) {
        return this.containers.get(bundle.getBundleId());
    }

    public Collection<CdiContainer> getContainers() {
        return Collections.unmodifiableCollection(this.containers.values());
    }

    public void removeContainer(Bundle bundle) {
        CdiContainer container = this.containers.remove(bundle.getBundleId());
        for (CdiContainerListener listener : this.listeners) {
            listener.preDestroy(container);
        }
    }

    public void addListener(CdiContainerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CdiContainerListener listener) {
        this.listeners.remove(listener);
    }
}

