/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.jdbc;

import java.util.Map;
import javax.sql.DataSource;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineFactory;
import org.apache.karaf.jaas.modules.encryption.EncryptionSupport;
import org.apache.karaf.jaas.modules.jdbc.JDBCBackingEngine;
import org.apache.karaf.jaas.modules.jdbc.JDBCLoginModule;
import org.apache.karaf.jaas.modules.jdbc.JDBCUtils;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCBackingEngineFactory
implements BackingEngineFactory {
    private final Logger logger = LoggerFactory.getLogger(JDBCBackingEngineFactory.class);

    @Override
    public BackingEngine build(Map options) {
        JDBCBackingEngine instance = null;
        String datasourceURL = (String)options.get("datasource");
        BundleContext bundleContext = (BundleContext)options.get(BundleContext.class.getName());
        String addUserStatement = (String)options.get("insert.user");
        String addRoleStatement = (String)options.get("insert.role");
        String deleteRoleStatement = (String)options.get("delete.role");
        String deleteAllUserRolesStatement = (String)options.get("delete.roles");
        String deleteUserStatement = (String)options.get("delete.user");
        String selectUsersQuery = (String)options.get("query.user");
        String selectRolesQuery = (String)options.get("query.role");
        try {
            DataSource dataSource = (DataSource)JDBCUtils.createDatasource(bundleContext, datasourceURL);
            EncryptionSupport encryptionSupport = new EncryptionSupport(options);
            instance = new JDBCBackingEngine(dataSource, encryptionSupport);
            if (addUserStatement != null) {
                instance.setAddUserStatement(addUserStatement);
            }
            if (addRoleStatement != null) {
                instance.setAddRoleStatement(addRoleStatement);
            }
            if (deleteRoleStatement != null) {
                instance.setDeleteRoleStatement(deleteRoleStatement);
            }
            if (deleteAllUserRolesStatement != null) {
                instance.setDeleteAllUserRolesStatement(deleteAllUserRolesStatement);
            }
            if (deleteUserStatement != null) {
                instance.setDeleteUserStatement(deleteUserStatement);
            }
            if (selectUsersQuery != null) {
                instance.setSelectUsersQuery(selectUsersQuery);
            }
            if (selectRolesQuery != null) {
                instance.setSelectRolesQuery(selectRolesQuery);
            }
        }
        catch (Exception e) {
            this.logger.error("Error creating JDBCBackingEngine.", (Throwable)e);
        }
        return instance;
    }

    @Override
    public String getModuleClass() {
        return JDBCLoginModule.class.getName();
    }
}

