/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import org.apache.qpid.client.ConnectionTuneParameters;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ConnectionOpenBody;
import org.apache.qpid.framing.ConnectionTuneBody;
import org.apache.qpid.framing.ConnectionTuneOkBody;
import org.apache.qpid.framing.MethodRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionTuneMethodHandler
implements StateAwareMethodListener<ConnectionTuneBody> {
    private static final Logger _logger = LoggerFactory.getLogger(ConnectionTuneMethodHandler.class);
    private static final ConnectionTuneMethodHandler _instance = new ConnectionTuneMethodHandler();

    public static ConnectionTuneMethodHandler getInstance() {
        return _instance;
    }

    protected ConnectionTuneMethodHandler() {
    }

    @Override
    public void methodReceived(AMQProtocolSession session, ConnectionTuneBody frame, int channelId) {
        _logger.debug("ConnectionTune frame received");
        MethodRegistry methodRegistry = session.getMethodRegistry();
        ConnectionTuneParameters params = session.getConnectionTuneParameters();
        int maxChannelNumber = frame.getChannelMax();
        params.setChannelMax(maxChannelNumber == 0 ? 65535 : maxChannelNumber);
        params.setFrameMax(frame.getFrameMax());
        if (params.getHeartbeat() == null) {
            params.setHeartbeat(frame.getHeartbeat());
        }
        session.tuneConnection(params);
        session.getStateManager().changeState(AMQState.CONNECTION_NOT_OPENED);
        ConnectionTuneOkBody tuneOkBody = methodRegistry.createConnectionTuneOkBody(params.getChannelMax(), params.getFrameMax(), params.getHeartbeat());
        session.writeFrame(tuneOkBody.generateFrame(channelId));
        String host = session.getAMQConnection().getVirtualHost();
        AMQShortString virtualHost = new AMQShortString("/" + host);
        ConnectionOpenBody openBody = methodRegistry.createConnectionOpenBody(virtualHost, null, true);
        session.writeFrame(openBody.generateFrame(channelId));
    }
}

