/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.state;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.StateWaiter;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.protocol.AMQMethodEvent;
import org.apache.qpid.protocol.AMQMethodListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQStateManager
implements AMQMethodListener {
    private static final Logger _logger = LoggerFactory.getLogger(AMQStateManager.class);
    private AMQProtocolSession _protocolSession;
    private AMQState _currentState;
    private final Object _stateLock = new Object();
    private static final long MAXIMUM_STATE_WAIT_TIME = Long.parseLong(System.getProperty("amqj.MaximumStateWait", "30000"));
    private final List<StateWaiter> _waiters = new CopyOnWriteArrayList<StateWaiter>();
    private Exception _lastException;

    public AMQStateManager() {
        this(null);
    }

    public AMQStateManager(AMQProtocolSession protocolSession) {
        this(AMQState.CONNECTION_NOT_STARTED, protocolSession);
    }

    protected AMQStateManager(AMQState state, AMQProtocolSession protocolSession) {
        this._protocolSession = protocolSession;
        this._currentState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AMQState getCurrentState() {
        Object object = this._stateLock;
        synchronized (object) {
            return this._currentState;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeState(AMQState newState) {
        _logger.debug("State changing to " + (Object)((Object)newState) + " from old state " + (Object)((Object)this._currentState));
        Object object = this._stateLock;
        synchronized (object) {
            this._currentState = newState;
            _logger.debug("Notififying State change to " + this._waiters.size() + " : " + this._waiters);
            for (StateWaiter waiter : this._waiters) {
                waiter.received(newState);
            }
        }
    }

    @Override
    public <B extends AMQMethodBody> boolean methodReceived(AMQMethodEvent<B> evt) throws AMQException {
        B method = evt.getMethod();
        method.execute(this._protocolSession.getMethodDispatcher(), evt.getChannelId());
        return true;
    }

    public void setProtocolSession(AMQProtocolSession session) {
        if (_logger.isDebugEnabled()) {
            _logger.debug("Setting ProtocolSession:" + session);
        }
        this._protocolSession = session;
    }

    @Override
    public void error(Exception error) {
        if (error instanceof AMQException) {
            if (((AMQException)error).isHardError()) {
                this.changeState(AMQState.CONNECTION_CLOSING);
            }
        } else {
            this.changeState(AMQState.CONNECTION_CLOSED);
        }
        if (this._waiters.size() == 0) {
            _logger.info("No Waiters for error. Saving as last error:" + error.getMessage());
            this._lastException = error;
        }
        for (StateWaiter waiter : this._waiters) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Notifying waiter " + waiter + " for error:" + error.getMessage());
            }
            waiter.error(error);
        }
    }

    public long getWaitTimeout() {
        return MAXIMUM_STATE_WAIT_TIME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StateWaiter createWaiter(Set<AMQState> states) {
        StateWaiter waiter;
        Object object = this._stateLock;
        synchronized (object) {
            waiter = new StateWaiter(this, this._currentState, states);
            this._waiters.add(waiter);
        }
        return waiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWaiter(StateWaiter waiter) {
        Object object = this._stateLock;
        synchronized (object) {
            this._waiters.remove(waiter);
        }
    }

    public Exception getLastException() {
        return this._lastException;
    }

    public void clearLastException() {
        this._lastException = null;
    }
}

