/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import org.apache.qpid.framing.AMQType;
import org.apache.qpid.framing.AMQTypeMap;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.FieldTable;

public abstract class AMQTypedValue {
    private static final AMQTypedValue[] INT_VALUES = new AMQTypedValue[16];

    public abstract AMQType getType();

    public abstract Object getValue();

    public abstract void writeToBuffer(DataOutput var1) throws IOException;

    public abstract int getEncodingSize();

    public static AMQTypedValue readFromBuffer(DataInput buffer) throws IOException {
        AMQType type = AMQTypeMap.getType(buffer.readByte());
        switch (type) {
            case LONG: {
                return new LongTypedValue(buffer);
            }
            case INT: {
                int value = EncodingUtils.readInteger(buffer);
                return AMQTypedValue.createAMQTypedValue(value);
            }
        }
        return new GenericTypedValue(type, buffer);
    }

    public static AMQTypedValue createAMQTypedValue(int i) {
        return (i & 0xF) == i ? INT_VALUES[i] : new IntTypedValue(i);
    }

    public static AMQTypedValue createAMQTypedValue(long value) {
        return new LongTypedValue(value);
    }

    public static AMQTypedValue createAMQTypedValue(AMQType type, Object value) {
        switch (type) {
            case LONG: {
                return new LongTypedValue((Long)AMQType.LONG.toNativeValue(value));
            }
            case INT: {
                return new IntTypedValue((Integer)AMQType.INT.toNativeValue(value));
            }
        }
        return new GenericTypedValue(type, value);
    }

    public static AMQTypedValue toTypedValue(Object val) {
        if (val == null) {
            return AMQType.VOID.asTypedValue(null);
        }
        Class<?> klass = val.getClass();
        if (klass == String.class) {
            return AMQType.ASCII_STRING.asTypedValue(val);
        }
        if (klass == Character.class) {
            return AMQType.ASCII_CHARACTER.asTypedValue(val);
        }
        if (klass == Integer.class) {
            return AMQType.INT.asTypedValue(val);
        }
        if (klass == Long.class) {
            return AMQType.LONG.asTypedValue(val);
        }
        if (klass == Float.class) {
            return AMQType.FLOAT.asTypedValue(val);
        }
        if (klass == Double.class) {
            return AMQType.DOUBLE.asTypedValue(val);
        }
        if (klass == Date.class) {
            return AMQType.TIMESTAMP.asTypedValue(val);
        }
        if (klass == Byte.class) {
            return AMQType.BYTE.asTypedValue(val);
        }
        if (klass == Boolean.class) {
            return AMQType.BOOLEAN.asTypedValue(val);
        }
        if (klass == byte[].class) {
            return AMQType.BINARY.asTypedValue(val);
        }
        if (klass == BigDecimal.class) {
            return AMQType.DECIMAL.asTypedValue(val);
        }
        if (val instanceof Map) {
            return AMQType.FIELD_TABLE.asTypedValue(FieldTable.convertToFieldTable((Map)val));
        }
        return null;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            AMQTypedValue.INT_VALUES[i] = new IntTypedValue(i);
        }
    }

    private static final class IntTypedValue
    extends AMQTypedValue {
        private final int _value;

        public String toString() {
            return "[INT: " + String.valueOf(this._value) + "]";
        }

        public IntTypedValue(int value) {
            this._value = value;
        }

        @Override
        public AMQType getType() {
            return AMQType.INT;
        }

        @Override
        public Object getValue() {
            return this._value;
        }

        @Override
        public void writeToBuffer(DataOutput buffer) throws IOException {
            EncodingUtils.writeByte(buffer, AMQType.INT.identifier());
            EncodingUtils.writeInteger(buffer, this._value);
        }

        @Override
        public int getEncodingSize() {
            return EncodingUtils.encodedIntegerLength();
        }
    }

    private static final class LongTypedValue
    extends AMQTypedValue {
        private final long _value;

        private LongTypedValue(long value) {
            this._value = value;
        }

        public LongTypedValue(DataInput buffer) throws IOException {
            this._value = EncodingUtils.readLong(buffer);
        }

        @Override
        public AMQType getType() {
            return AMQType.LONG;
        }

        @Override
        public Object getValue() {
            return this._value;
        }

        @Override
        public void writeToBuffer(DataOutput buffer) throws IOException {
            EncodingUtils.writeByte(buffer, AMQType.LONG.identifier());
            EncodingUtils.writeLong(buffer, this._value);
        }

        @Override
        public int getEncodingSize() {
            return EncodingUtils.encodedLongLength();
        }
    }

    private static final class GenericTypedValue
    extends AMQTypedValue {
        private final AMQType _type;
        private final Object _value;

        private GenericTypedValue(AMQType type, Object value) {
            if (type == null) {
                throw new NullPointerException("Cannot create a typed value with null type");
            }
            this._type = type;
            this._value = type.toNativeValue(value);
        }

        private GenericTypedValue(AMQType type, DataInput buffer) throws IOException {
            this._type = type;
            this._value = type.readValueFromBuffer(buffer);
        }

        @Override
        public AMQType getType() {
            return this._type;
        }

        @Override
        public Object getValue() {
            return this._value;
        }

        @Override
        public void writeToBuffer(DataOutput buffer) throws IOException {
            this._type.writeToBuffer(this._value, buffer);
        }

        @Override
        public int getEncodingSize() {
            return this._type.getEncodingSize(this._value);
        }

        public String toString() {
            return "[" + (Object)((Object)this.getType()) + ": " + this.getValue() + "]";
        }

        public boolean equals(Object o) {
            if (o instanceof GenericTypedValue) {
                GenericTypedValue other = (GenericTypedValue)o;
                return this._type == other._type && (this._value == null ? other._value == null : this._value.equals(other._value));
            }
            return false;
        }

        public int hashCode() {
            return this._type.hashCode() ^ (this._value == null ? 0 : this._value.hashCode());
        }
    }
}

