/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.util.Arrays;
import java.util.List;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.apache.karaf.shell.console.jline.CommandSessionHolder;
import org.switchyard.admin.Application;
import org.switchyard.admin.SwitchYard;
import org.switchyard.config.model.switchyard.ArtifactModel;
import org.switchyard.deploy.karaf.UsesArtifactCommand;

public class ArtifactCompleter
implements Completer {
    private SwitchYard _switchYard;

    public int complete(String buffer, int cursor, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        UsesArtifactCommand.SearchType type = this.getType();
        for (Application application : this._switchYard.getApplications()) {
            if (application.getConfig().getArtifacts() == null) continue;
            for (ArtifactModel artifact : application.getConfig().getArtifacts().getArtifacts()) {
                switch (type) {
                    case name: {
                        delegate.getStrings().add(artifact.getName());
                        break;
                    }
                    case url: {
                        delegate.getStrings().add(artifact.getURL());
                    }
                }
            }
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    public void setSwitchYard(SwitchYard switchYard) {
        this._switchYard = switchYard;
    }

    private UsesArtifactCommand.SearchType getType() {
        CommandSession session = CommandSessionHolder.getSession();
        if (session == null) {
            return null;
        }
        ArgumentCompleter.ArgumentList argList = (ArgumentCompleter.ArgumentList)session.get("ARGUMENTS_LIST");
        if (argList == null || argList.getArguments() == null || argList.getArguments().length == 0) {
            return null;
        }
        List<String> arguments = Arrays.asList(argList.getArguments());
        int argumentOffset = 1;
        int count = arguments.size();
        for (int index = 0; index < count; ++index) {
            if (!arguments.get(index).startsWith("-")) continue;
            argumentOffset = index;
        }
        if (argumentOffset < arguments.size()) {
            return UsesArtifactCommand.SearchType.valueOf(arguments.get(argumentOffset));
        }
        return null;
    }
}

